/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.utils;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleUtils {
    private BundleUtils() {
    }

    public static Bundle installOrStopBundle(BundleContext bundleContext, String bsn, String url) throws BundleException {
        Bundle bundle = BundleUtils.findBundle(bundleContext, bsn);
        if (bundle == null) {
            bundle = bundleContext.installBundle(url);
        }
        if (bundle.getState() == 32) {
            bundle.stop();
        }
        return bundle;
    }

    public static Bundle findBundle(BundleContext bundleContext, String bsn) throws BundleException {
        for (Bundle b : bundleContext.getBundles()) {
            if (b.getSymbolicName() == null || !b.getSymbolicName().equals(bsn)) continue;
            return b;
        }
        return null;
    }

    public static Bundle findAndStopBundle(BundleContext bundleContext, String bsn) throws BundleException {
        Bundle bundle = BundleUtils.findBundle(bundleContext, bsn);
        if (bundle != null && bundle.getState() == 32) {
            bundle.stop();
        }
        return bundle;
    }

    public static Bundle findOrInstallBundle(BundleContext bundleContext, String bsn, String url) throws BundleException {
        Bundle bundle = BundleUtils.findBundle(bundleContext, bsn);
        return bundle != null ? bundle : bundleContext.installBundle(url);
    }
}

