/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="set", scope="zk", description="Set a znode's data", detailedDescription="classpath:set.txt")
public class Set
extends ZooKeeperCommandSupport {
    @Option(name="-i", aliases={"--import"}, description="Import data from a URL")
    boolean importUrl;
    @Argument(description="Path of the znode to set", index=0)
    String path;
    @Argument(description="The new data or URL, if the '--import' option is specified", index=1)
    String data;

    @Override
    protected void doExecute(IZKClient zk) throws Exception {
        String nodeData = this.data;
        if (this.importUrl) {
            nodeData = this.loadUrl(new URL(this.data));
        }
        zk.setData(this.path, nodeData);
    }
}

