/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;
import org.linkedin.zookeeper.client.IZKClient;

@Command(name="list", scope="zk", description="List a znode's children", detailedDescription="classpath:list.txt")
public class List
extends ZooKeeperCommandSupport {
    @Argument(description="Path of the znode to list")
    String path = "/";
    @Option(name="-r", aliases={"--recursive"}, description="List children recursively")
    boolean recursive = false;
    @Option(name="-d", aliases={"--display"}, description="Display a znode's value if set")
    boolean display = false;

    @Override
    protected void doExecute(IZKClient zk) throws Exception {
        this.display(zk, this.path);
    }

    private java.util.List<String> getPaths(IZKClient zk) throws Exception {
        if (this.recursive) {
            return zk.getAllChildren(this.path);
        }
        return zk.getChildren(this.path);
    }

    protected void display(IZKClient zk, String path) throws Exception {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        java.util.List<String> paths = this.getPaths(zk);
        for (String p : paths) {
            if (this.display) {
                byte[] data = zk.getData(path + p);
                if (data != null) {
                    System.out.printf("%s = %s\n", p, new String(data));
                    continue;
                }
                System.out.println(p);
                continue;
            }
            System.out.println(p);
        }
    }
}

