/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands.support;

import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.linkedin.zookeeper.client.IZKClient;

public class ProfileCompleter
implements Completer {
    protected FabricService fabricService;
    protected IZKClient zooKeeper;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        String versionName = null;
        try {
            Profile[] profiles;
            Version defaultVersion = this.fabricService.getDefaultVersion();
            if (defaultVersion != null) {
                versionName = defaultVersion.getName();
            }
            if (versionName == null) {
                versionName = "1.0";
            }
            for (Profile profile : profiles = this.fabricService.getProfiles(versionName)) {
                delegate.getStrings().add(profile.getId());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

