/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.zookeeper.commands.RegexSupport;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="import", scope="zk", description="Import data into zookeeper")
public class Import
extends ZooKeeperCommandSupport {
    @Argument(description="Location of the file or filesystem to load")
    protected String source = "." + File.separator + "import";
    @Option(name="-d", aliases={"--delete"}, description="Delete any paths not in the tree being imported, ignored when importing a properties file (CAUTION!)")
    boolean delete = false;
    @Option(name="-t", aliases={"--target"}, description="Target location in ZooKeeper tree to import to")
    String target = "/";
    @Option(name="-props", aliases={"--properties"}, description="Argument is URL pointing to a properties file")
    boolean properties = false;
    @Option(name="-fs", aliases={"--filesystem"}, description="Argument is the top level directory of a local filesystem tree")
    boolean filesystem = true;
    @Option(name="-v", aliases={"--verbose"}, description="Verbose output of files being imported")
    boolean verbose = false;
    @Option(name="-f", aliases={"--regex"}, description="regex to filter on what paths to import, can specify this option more than once for additional filters", multiValued=true)
    String[] regex;
    @Option(name="-rf", aliases={"--reverse-regex"}, description="regex to filter what paths to exclude, can specify this option more than once for additional filters", multiValued=true)
    protected String[] nregex;
    @Option(name="--dry-run", description="Runs the import but prints out what's going to happen instead of making any changes")
    boolean dryRun = false;
    File ignore = new File(".fabricignore");
    File include = new File(".fabricinclude");

    protected Object doExecute() throws Exception {
        if (this.ignore.exists() && this.ignore.isFile()) {
            this.nregex = RegexSupport.merge(this.ignore, this.nregex);
        }
        if (this.include.exists() && this.include.isFile()) {
            this.regex = RegexSupport.merge(this.include, this.regex);
        }
        if (this.properties) {
            this.filesystem = false;
        }
        if (this.filesystem) {
            this.properties = false;
        }
        this.checkZooKeeperConnected();
        if (this.properties) {
            this.readPropertiesFile();
        }
        if (this.filesystem) {
            this.readFileSystem();
        }
        System.out.println("imported ZK data from: " + this.source);
        return null;
    }

    private String buildZKPath(File parent, File current) {
        String rc = "";
        if (current != null && !parent.equals(current)) {
            rc = this.buildZKPath(parent, current.getParentFile()) + "/" + current.getName();
        }
        return rc;
    }

    private void getCandidates(File parent, File current, Map<String, String> settings) throws Exception {
        List<Pattern> profile = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*"});
        List<Pattern> agentProperties = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*/org.fusesource.fabric.agent.properties"});
        if (current.isDirectory()) {
            for (File child : current.listFiles()) {
                this.getCandidates(parent, child, settings);
            }
            String p = this.buildZKPath(parent, current).replaceFirst("/", "");
            if (!RegexSupport.matches(profile, "/" + p, false)) {
                settings.put(p, null);
            }
        } else {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(current));
            byte[] contents = new byte[in.available()];
            in.read(contents);
            in.close();
            String p = this.buildZKPath(parent, current).replaceFirst("/", "");
            if (p.endsWith(".cfg")) {
                p = p.substring(0, p.length() - ".cfg".length());
            }
            if (RegexSupport.matches(agentProperties, "/" + p, false)) {
                settings.put(p, new String(contents).replaceAll("parents=[[\\w\\-\\.]*[ \\t]]*", ""));
                Properties props = new Properties();
                props.load(new StringReader(new String(contents)));
                String parents = (String)props.get("parents");
                settings.put(p.substring(0, p.lastIndexOf("/")), parents);
            } else if (!RegexSupport.matches(profile, "/" + p, false)) {
                settings.put(p, new String(contents));
            }
        }
    }

    private void readFileSystem() throws Exception {
        TreeMap<String, String> settings = new TreeMap<String, String>();
        File s = new File(this.source);
        this.getCandidates(s, s, settings);
        List<Pattern> include = RegexSupport.getPatterns(this.regex);
        List<Pattern> exclude = RegexSupport.getPatterns(this.nregex);
        if (!this.target.endsWith("/")) {
            this.target = this.target + "/";
        }
        if (!this.target.startsWith("/")) {
            this.target = "/" + this.target;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String key : settings.keySet()) {
            String data = (String)settings.get(key);
            key = this.target + key;
            paths.add(key);
            if (!RegexSupport.matches(include, key, true) || RegexSupport.matches(exclude, key, false)) continue;
            if (!this.dryRun) {
                if (data == null) continue;
                if (this.verbose) {
                    System.out.println("importing: " + key);
                }
                this.getZooKeeper().createOrSetWithParents(key, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            System.out.printf("Creating path \"%s\" with value \"%s\"\n", key, data);
        }
        if (this.delete) {
            this.deletePathsNotIn(paths);
        }
    }

    private void deletePathsNotIn(List<String> paths) throws Exception {
        List zkPaths = this.getZooKeeper().getAllChildren(this.target);
        for (String path : zkPaths) {
            path = "/" + path;
            if (paths.contains(path)) continue;
            if (!this.dryRun) {
                this.getZooKeeper().deleteWithChildren(path);
                continue;
            }
            System.out.printf("Deleting path %s and everything under it\n", path);
        }
    }

    private void readPropertiesFile() throws Exception {
        List<Pattern> includes = RegexSupport.getPatterns(this.regex);
        List<Pattern> excludes = RegexSupport.getPatterns(this.nregex);
        BufferedInputStream in = new BufferedInputStream(new URL(this.source).openStream());
        ArrayList paths = new ArrayList();
        Properties props = new Properties();
        props.load(in);
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = props.getProperty(name);
            if (value != null && value.isEmpty()) {
                value = null;
            }
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!RegexSupport.matches(includes, name = this.target + name, true) || RegexSupport.matches(excludes, name, false)) continue;
            if (!this.dryRun) {
                this.getZooKeeper().createOrSetWithParents(name, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            System.out.printf("Creating path \"%s\" with value \"%s\"\n", name, value);
        }
    }

    public boolean isFilesystem() {
        return this.filesystem;
    }

    public void setFilesystem(boolean filesystem) {
        this.filesystem = filesystem;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

