/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.commands.RegexSupport;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="export", scope="zk", description="Export data from zookeeper")
public class Export
extends ZooKeeperCommandSupport {
    @Argument(description="path of the directory to export to")
    String target = "." + File.separator + "export";
    @Option(name="-f", aliases={"--regex"}, description="regex to filter on what paths to export, can specify this option more than once for additional filters", multiValued=true)
    String[] regex;
    @Option(name="-rf", aliases={"--reverse-regex"}, description="regex to filter what paths to exclude from the export, can specify this option more than once for additional filters", multiValued=true)
    String[] nregex;
    @Option(name="-p", aliases={"--path"}, description="Top level context to export")
    String topLevel = "/";
    @Option(name="-d", aliases={"--delete"}, description="Clear target directory before exporting (CAUTION! Performs recursive delete!)")
    boolean delete;
    @Option(name="-t", aliases={"--trim"}, description="Trims the first timestamp comment line in properties files starting with the '#' character")
    boolean trimHeader;
    @Option(name="--dry-run", description="Runs the export but instead prints out what's going to happen rather than performing the action")
    boolean dryRun = false;
    File ignore = new File(".fabricignore");
    File include = new File(".fabricinclude");

    protected Object doExecute() throws Exception {
        if (this.ignore.exists() && this.ignore.isFile()) {
            this.nregex = RegexSupport.merge(this.ignore, this.nregex);
        }
        if (this.include.exists() && this.include.isFile()) {
            this.regex = RegexSupport.merge(this.include, this.regex);
        }
        this.export(this.topLevel);
        System.out.printf("Export to %s completed successfully\n", this.target);
        return null;
    }

    private void delete(File parent) throws Exception {
        if (!parent.exists()) {
            return;
        }
        if (parent.isDirectory()) {
            for (File f : parent.listFiles()) {
                this.delete(f);
            }
        }
        parent.delete();
    }

    protected void export(String path) throws Exception {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        List<Pattern> include = RegexSupport.getPatterns(this.regex);
        List<Pattern> exclude = RegexSupport.getPatterns(this.nregex);
        List<Pattern> profile = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*"});
        List<Pattern> agentProperties = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*/org.fusesource.fabric.agent.properties"});
        List paths = this.getZooKeeper().getAllChildren(path);
        TreeSet<File> directories = new TreeSet<File>();
        HashMap<File, String> settings = new HashMap<File, String>();
        for (String p : paths) {
            p = path + p;
            if (!RegexSupport.matches(include, p, true) || RegexSupport.matches(exclude, p, false) || RegexSupport.matches(profile, p, false)) continue;
            byte[] data = this.getZooKeeper().getData(p);
            if (data != null) {
                byte[] parentData;
                int idx;
                String name = p;
                if (!p.contains(".")) {
                    name = name + ".cfg";
                }
                String value = new String(data);
                if (this.trimHeader && value.startsWith("#") && (idx = value.indexOf("\n")) > 0) {
                    value = value.substring(idx + 1);
                }
                if (RegexSupport.matches(agentProperties, p, false) && (parentData = this.getZooKeeper().getData(p.substring(0, p.lastIndexOf("/")))) != null) {
                    String parentValue = "parents=" + new String(parentData);
                    value = value + "\n" + parentValue;
                }
                settings.put(new File(this.target + File.separator + name), value);
                continue;
            }
            directories.add(new File(this.target + File.separator + p));
        }
        if (this.delete) {
            if (!this.dryRun) {
                this.delete(new File(this.target));
            } else {
                System.out.printf("Deleting %s and everything under it\n", new File(this.target));
            }
        }
        for (File d : directories) {
            if (d.exists() && !d.isDirectory()) {
                throw new IllegalArgumentException("Directory " + d + " exists but is not a directory");
            }
            if (d.exists()) continue;
            if (!this.dryRun) {
                if (d.mkdirs()) continue;
                throw new RuntimeException("Failed to create directory " + d);
            }
            System.out.printf("Creating directory path : %s\n", d);
        }
        for (File f : settings.keySet()) {
            if (f.exists() && !f.isFile()) {
                throw new IllegalArgumentException("File " + f + " exists but is not a file");
            }
            if (!f.getParentFile().exists()) {
                if (!this.dryRun) {
                    if (!f.getParentFile().mkdirs()) {
                        throw new RuntimeException("Failed to create directory " + f.getParentFile());
                    }
                } else {
                    System.out.printf("Creating directory path : %s\n", f);
                }
            }
            if (!f.exists()) {
                try {
                    if (!this.dryRun) {
                        if (!f.createNewFile()) {
                            throw new RuntimeException("Failed to create file " + f);
                        }
                    } else {
                        System.out.printf("Creating file : %s\n", f);
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException("Failed to create file " + f + " : " + io);
                }
            }
            if (!this.dryRun) {
                FileWriter writer = new FileWriter(f, false);
                writer.write((String)settings.get(f));
                writer.close();
                continue;
            }
            System.out.printf("Writing value \"%s\" to file : %s\n", settings.get(f), f);
        }
    }
}

