/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.linkedin.zookeeper.client.IZKClient;

public abstract class ZooKeeperCommandSupport
extends OsgiCommandSupport {
    private IZKClient zooKeeper;

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    protected static String getPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    protected static List<ACL> parseACLs(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZooKeeperCommandSupport.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    protected static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    protected String loadUrl(URL url) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuffer content = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            content.append(line);
            content.append(System.getProperty("line.separator"));
        }
        return content.toString();
    }
}

