/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="list", scope="zk", description="List a node's children")
public class List
extends ZooKeeperCommandSupport {
    @Option(name="-r", aliases={"--recursive"}, description="Display children recursively")
    boolean recursive;
    @Argument(description="Path of the node to list", required=true)
    String path;

    protected Object doExecute() throws Exception {
        this.display(this.path);
        return null;
    }

    protected void display(String path) throws Exception {
        java.util.List children = this.getZooKeeper().getChildren(path);
        for (String child : children) {
            String cp = path.endsWith("/") ? path + child : path + "/" + child;
            System.out.println(cp);
            if (!this.recursive) continue;
            this.display(cp);
        }
    }
}

