/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="import", scope="zk", description="Import data into zookeeper")
public class Import
extends ZooKeeperCommandSupport {
    @Argument(description="URL of the file to load")
    String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        BufferedInputStream in = new BufferedInputStream(new URL(this.url).openStream());
        try {
            Properties props = new Properties();
            props.load(in);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                if (value != null && value.isEmpty()) {
                    value = null;
                }
                this.getZooKeeper().createOrSetWithParents(name, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return null;
    }
}

