/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.util.ArrayList;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="export", scope="zk", description="Export data from zookeeper")
public class Export
extends ZooKeeperCommandSupport {
    protected Object doExecute() throws Exception {
        this.display("/");
        return null;
    }

    protected void display(String path) throws Exception {
        String sep;
        String[] lines;
        ArrayList<String> paths = new ArrayList<String>();
        for (String child : this.getZooKeeper().getChildren(path)) {
            String cp;
            String string = cp = path.endsWith("/") ? path + child : path + "/" + child;
            if (this.getZooKeeper().exists(cp).getEphemeralOwner() != 0L) continue;
            paths.add(cp);
        }
        String data = this.getZooKeeper().getStringData(path);
        if (data != null && !data.isEmpty() && (lines = data.split(sep = System.getProperty("line.separator"))).length > 10) {
            data = lines[0] + sep + lines[1] + sep + lines[2] + sep + " ... (truncated) ..." + sep + lines[lines.length - 3] + sep + lines[lines.length - 2] + sep + lines[lines.length - 1];
        }
        if (data != null && !data.isEmpty() || paths.isEmpty()) {
            System.out.println(data != null && !data.isEmpty() ? path + " = " + data : path);
        }
        for (String child : paths) {
            this.display(child);
        }
    }
}

