/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="delete", scope="zk", description="Delete a node")
public class Delete
extends ZooKeeperCommandSupport {
    @Option(name="-v", aliases={"--version "}, description="Version to delete")
    int version = -1;
    @Option(name="-r", aliases={"--recursive"}, description="Automatically create parents")
    boolean recursive;
    @Argument(description="Path of the node to delete")
    String path;

    protected Object doExecute() throws Exception {
        if (this.recursive) {
            if (this.version >= 0) {
                throw new UnsupportedOperationException("Unable to delete a version recursively");
            }
            this.getZooKeeper().deleteWithChildren(this.path);
        } else {
            this.getZooKeeper().delete(this.path, this.version);
        }
        return null;
    }
}

