/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="create", scope="zk", description="Create a node")
public class Create
extends ZooKeeperCommandSupport {
    @Option(name="-e", aliases={"--ephemeral"}, description="Create an ephemeral node")
    boolean ephemeral;
    @Option(name="-s", aliases={"--sequential"}, description="Create a sequential node")
    boolean sequential;
    @Option(name="-r", aliases={"--recursive"}, description="Automatically create parents")
    boolean recursive;
    @Option(name="-i", aliases={"--import"}, description="Import data from an url")
    boolean importUrl;
    @Option(name="-a", aliases={"--acl"}, description="Node ACLs")
    String acl;
    @Argument(index=0, required=true, description="Path of the node to create")
    String path;
    @Argument(index=1, required=false, description="Data for the node, or url if 'import' option is used")
    String data;

    protected Object doExecute() throws Exception {
        ArrayList acls;
        List<Object> list = acls = this.acl == null ? ZooDefs.Ids.OPEN_ACL_UNSAFE : Create.parseACLs(this.acl);
        CreateMode mode = this.ephemeral && this.sequential ? CreateMode.EPHEMERAL_SEQUENTIAL : (this.ephemeral ? CreateMode.EPHEMERAL : (this.sequential ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.PERSISTENT));
        String nodeData = this.data;
        if (this.importUrl) {
            nodeData = this.loadUrl(new URL(this.data));
        }
        if (this.recursive) {
            this.getZooKeeper().createWithParents(this.path, nodeData, (List)acls, mode);
        } else {
            this.getZooKeeper().create(this.path, nodeData, (List)acls, mode);
        }
        return null;
    }
}

