/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.fusesource.fabric.utils.Closeables;

public class Files {
    private static final int BUFFER_SIZE = 8192;

    public static File createTempFile() throws IOException {
        File dataDir = new File(System.getProperty("karaf.data"));
        File tmpDir = new File(dataDir, "tmp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to create tmp dir:" + tmpDir.getAbsolutePath());
        }
        return File.createTempFile(String.valueOf(System.currentTimeMillis()), ".tmp", tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file, Charset charset) throws IOException {
        ByteArrayOutputStream bos;
        FileInputStream fis;
        block5: {
            String string;
            fis = null;
            bos = null;
            if (file == null) {
                throw new FileNotFoundException("No file specified");
            }
            try {
                int remaining;
                fis = new FileInputStream(file);
                bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((remaining = fis.read(buffer)) > 0) {
                    bos.write(buffer, 0, remaining);
                }
                if (charset == null) break block5;
                string = new String(bos.toByteArray(), charset);
            }
            catch (Throwable throwable) {
                Closeables.closeQuitely(fis);
                Closeables.closeQuitely(bos);
                throw throwable;
            }
            Closeables.closeQuitely(fis);
            Closeables.closeQuitely(bos);
            return string;
        }
        String string = new String(bos.toByteArray());
        Closeables.closeQuitely(fis);
        Closeables.closeQuitely(bos);
        return string;
    }

    public static String toString(File file) throws IOException {
        return Files.toString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String content, Charset charset) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            if (file == null) {
                throw new FileNotFoundException("No file specified.");
            }
            if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new FileNotFoundException("Could not find or create file:" + file.getName());
            }
            fos = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fos, charset);
            writer.write(content, 0, content.length());
            writer.flush();
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(fos);
            Closeables.closeQuitely(writer);
            throw throwable;
        }
        Closeables.closeQuitely(fos);
        Closeables.closeQuitely(writer);
    }

    public static void copy(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source file not found:" + source.getAbsolutePath());
        }
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Can't create target directory:" + target.getParentFile().getAbsolutePath());
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(target);
        Files.copy(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            Closeables.closeQuitely(is);
            Closeables.closeQuitely(os);
        }
    }
}

