/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.fusesource.fabric.api.HasId;
import org.fusesource.fabric.api.Version;

public class VersionDTO
implements HasId {
    private String id;
    private Properties attributes;
    private boolean defaultVersion;

    public static VersionDTO newInstance(Version version) {
        if (version != null) {
            return new VersionDTO(version);
        }
        return null;
    }

    public static List<VersionDTO> newInstances(Version ... versions) {
        ArrayList<VersionDTO> answer = new ArrayList<VersionDTO>();
        if (versions != null) {
            for (Version version : versions) {
                VersionDTO dto = VersionDTO.newInstance(version);
                if (dto == null) continue;
                answer.add(dto);
            }
        }
        return answer;
    }

    public VersionDTO() {
    }

    public VersionDTO(Version version) {
        this.id = version.getName();
        this.attributes = version.getAttributes();
    }

    public String toString() {
        return "VersionDTO(" + this.id + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionDTO that = (VersionDTO)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }
}

