/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.io.File;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateEnsembleOptions;
import org.fusesource.fabric.api.CreateRemoteContainerOptions;

public class CreateSshContainerOptions
extends CreateContainerBasicOptions<CreateSshContainerOptions>
implements CreateRemoteContainerOptions<CreateSshContainerOptions> {
    private static final long serialVersionUID = -1171578973712670970L;
    public static final String DEFAULT_PRIVATE_KEY_FILE = System.getProperty("user.home") + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa";
    static final int DEFAULT_SSH_RETRIES = 1;
    static final int DEFAULT_SSH_PORT = 22;
    private String username;
    private String password;
    private String host;
    private int port = 22;
    private int sshRetries = 1;
    private int retryDelay = 1;
    private String privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
    private String passPhrase;
    private CreateEnsembleOptions createEnsembleOptions = CreateEnsembleOptions.build();
    private String path = "~/containers/";

    public CreateSshContainerOptions() {
        this.providerType = "ssh";
    }

    public String toString() {
        return "createSshContainer(" + this.getUsername() + "@" + this.getHost() + ":" + this.getPort() + " " + this.getPath() + ")";
    }

    public CreateSshContainerOptions username(String username) {
        this.username = username;
        return this;
    }

    public CreateSshContainerOptions password(String password) {
        this.password = password;
        return this;
    }

    public CreateSshContainerOptions host(String host) {
        this.host = host;
        return this;
    }

    public CreateSshContainerOptions port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public CreateSshContainerOptions path(String path) {
        this.path = path;
        return this;
    }

    public CreateSshContainerOptions sshRetries(int sshRetries) {
        this.sshRetries = sshRetries;
        return this;
    }

    public CreateSshContainerOptions retryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public CreateSshContainerOptions privateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
        return this;
    }

    public CreateSshContainerOptions passPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
        return this;
    }

    public CreateSshContainerOptions createEnsembleOptions(CreateEnsembleOptions createEnsembleOptions) {
        this.createEnsembleOptions = createEnsembleOptions;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSshRetries() {
        return this.sshRetries;
    }

    public void setSshRetries(int sshRetries) {
        this.sshRetries = sshRetries;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    @Override
    public CreateEnsembleOptions getCreateEnsembleOptions() {
        return this.createEnsembleOptions;
    }

    @Override
    public void setCreateEnsembleOptions(CreateEnsembleOptions createEnsembleOptions) {
        this.createEnsembleOptions = createEnsembleOptions;
    }

    public CreateSshContainerOptions clone() throws CloneNotSupportedException {
        return (CreateSshContainerOptions)super.clone();
    }
}

