/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.util.LinkedHashSet;
import java.util.Set;
import org.fusesource.fabric.api.CreateContainerBasicMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;

public class CreateJCloudsContainerMetadata
extends CreateContainerBasicMetadata<CreateJCloudsContainerOptions> {
    private String nodeId;
    private String hostname;
    private Set<String> publicAddresses = new LinkedHashSet<String>();
    private Set<String> privateAddresses = new LinkedHashSet<String>();
    private String identity;
    private String credential;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.getContainerConfiguration().put("localhostname", hostname);
    }

    public Set<String> getPublicAddresses() {
        return this.publicAddresses;
    }

    public void setPublicAddresses(Set<String> publicAddresses) {
        this.publicAddresses = publicAddresses;
        if (publicAddresses != null && publicAddresses.size() > 0) {
            this.getContainerConfiguration().put("publicip", publicAddresses.toArray(new String[0])[0]);
        }
    }

    public Set<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    public void setPrivateAddresses(Set<String> privateAddresses) {
        this.privateAddresses = privateAddresses;
        if (privateAddresses != null && privateAddresses.size() > 0) {
            this.getContainerConfiguration().put("localip", privateAddresses.toArray(new String[0])[0]);
        }
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getContainerName()).append("[").append("public ip=[ ");
        for (String ip : this.publicAddresses) {
            builder.append(ip).append(" ");
        }
        builder.append("]]");
        return builder.toString();
    }
}

