/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.JCloudsInstanceType;

public class CreateJCloudsContainerOptions
extends CreateContainerBasicOptions<CreateJCloudsContainerOptions> {
    private static final long serialVersionUID = 4489740280396972109L;
    private String osFamily;
    private String osVersion;
    private String imageId;
    private String hardwareId;
    private String locationId;
    private String group;
    private String user;
    private String providerName;
    private JCloudsInstanceType instanceType = JCloudsInstanceType.Fastest;
    private String identity;
    private String credential;
    private String owner;
    private final Map<String, String> serviceOptions = new HashMap<String, String>();
    private final Map<String, String> nodeOptions = new HashMap<String, String>();
    private Integer servicePort = 0;
    private String publicKeyFile;
    private transient Object computeService;

    public CreateJCloudsContainerOptions() {
        this.providerType = "jclouds";
        this.adminAccess = true;
    }

    public String toString() {
        return "CreateJCloudsContainerArguments{imageId='" + this.imageId + '\'' + ", hardwareId='" + this.hardwareId + '\'' + ", locationId='" + this.locationId + '\'' + ", group='" + this.group + '\'' + ", user='" + this.user + '\'' + ", instanceType='" + (Object)((Object)this.instanceType) + '\'' + '}';
    }

    public CreateJCloudsContainerOptions osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public CreateJCloudsContainerOptions osFamily(String osFamily) {
        this.osFamily = osFamily;
        return this;
    }

    public CreateJCloudsContainerOptions imageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public CreateJCloudsContainerOptions hardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
        return this;
    }

    public CreateJCloudsContainerOptions locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    public CreateJCloudsContainerOptions group(String group) {
        this.group = group;
        return this;
    }

    public CreateJCloudsContainerOptions user(String user) {
        this.user = user;
        return this;
    }

    public CreateJCloudsContainerOptions providerName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public CreateJCloudsContainerOptions instanceType(JCloudsInstanceType instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public CreateJCloudsContainerOptions identity(String identity) {
        this.identity = identity;
        return this;
    }

    public CreateJCloudsContainerOptions credential(String credential) {
        this.credential = credential;
        return this;
    }

    @Deprecated
    public CreateJCloudsContainerOptions owner(String owner) {
        this.owner = owner;
        if (owner != null) {
            this.serviceOptions.put("owner", owner);
        }
        return this;
    }

    public CreateJCloudsContainerOptions nodeOptions(Map<String, String> nodeOptions) {
        if (nodeOptions != null) {
            for (Map.Entry<String, String> entry : nodeOptions.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.nodeOptions.put(key, value);
            }
        }
        return this;
    }

    public CreateJCloudsContainerOptions serviceOptions(Map<String, String> serviceOptions) {
        if (serviceOptions != null) {
            for (Map.Entry<String, String> entry : serviceOptions.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.serviceOptions.put(key, value);
            }
        }
        return this;
    }

    public CreateJCloudsContainerOptions servicePort(Integer servicePort) {
        this.servicePort = servicePort;
        return this;
    }

    public CreateJCloudsContainerOptions publicKeyFile(String publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
        return this;
    }

    public String getImageId() {
        return this.imageId != null ? this.imageId : this.getParameters().get("imageId");
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getHardwareId() {
        return this.hardwareId != null ? this.hardwareId : this.getParameters().get("hardwareId");
    }

    public void setHardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
    }

    public String getLocationId() {
        return this.locationId != null ? this.locationId : this.getParameters().get("locationId");
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getGroup() {
        return this.group != null ? this.group : this.getParameters().get("group");
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getUser() {
        return this.user != null ? this.user : this.getParameters().get("user");
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getProviderName() {
        return this.providerName != null ? this.providerName : this.providerURI.getHost();
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public JCloudsInstanceType getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(JCloudsInstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Integer getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getPublicKeyFile() {
        return this.publicKeyFile;
    }

    public void setPublicKeyFile(String publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
    }

    public Map<String, String> getServiceOptions() {
        return this.serviceOptions;
    }

    public Map<String, String> getNodeOptions() {
        return this.nodeOptions;
    }

    public Object getComputeService() {
        return this.computeService;
    }

    public void setComputeService(Object computeService) {
        this.computeService = computeService;
    }
}

