/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.internal.ProfileImpl;

public class ProfileOverlayImpl
implements Profile {
    private final ProfileImpl self;
    private Map<String, Map<String, String>> rc;

    public ProfileOverlayImpl(ProfileImpl self) {
        this.self = self;
    }

    @Override
    public String getId() {
        return this.self.getId();
    }

    @Override
    public String getVersion() {
        return this.self.getVersion();
    }

    @Override
    public Profile[] getParents() {
        return this.self.getParents();
    }

    @Override
    public List<String> getBundles() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.BUNDLES);
    }

    @Override
    public List<String> getFabs() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.FABS);
    }

    @Override
    public List<String> getFeatures() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.FEATURES);
    }

    @Override
    public List<String> getRepositories() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.REPOSITORIES);
    }

    @Override
    public Container[] getAssociatedContainers() {
        return this.self.getAssociatedContainers();
    }

    @Override
    public Map<String, String> getContainerConfiguration() {
        Map<String, String> map = this.getConfigurations().get("org.fusesource.fabric.agent");
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    @Override
    public void setFileConfigurations(Map<String, byte[]> configurations) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setParents(Profile[] parents) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setBundles(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setFabs(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setFeatures(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public void setRepositories(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    @Override
    public boolean configurationEquals(Profile other) {
        return this.self.configurationEquals(other);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Can not delete an overlay profile");
    }

    @Override
    public Profile getOverlay() {
        return this;
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    @Override
    public int compareTo(Profile profile) {
        return this.self.compareTo(profile);
    }

    @Override
    public Map<String, byte[]> getFileConfigurations() {
        try {
            HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
            this.supplement(this.self, aggregate);
            HashMap<String, byte[]> rc = new HashMap<String, byte[]>();
            for (Map.Entry entry : aggregate.entrySet()) {
                SupplementControl ctrl = (SupplementControl)entry.getValue();
                if (ctrl.props != null) {
                    ctrl.data = ProfileImpl.toBytes(ctrl.props);
                }
                rc.put((String)entry.getKey(), ctrl.data);
            }
            return rc;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    private void supplement(Profile profile, Map<String, SupplementControl> aggregate) throws Exception {
        for (Profile p : profile.getParents()) {
            this.supplement(p, aggregate);
        }
        if (profile instanceof ProfileOverlayImpl && ((ProfileOverlayImpl)profile).self.equals(this.self)) {
            return;
        }
        Map<String, byte[]> configs = profile.getFileConfigurations();
        for (Map.Entry<String, byte[]> entry : configs.entrySet()) {
            SupplementControl ctrl;
            String fileName = entry.getKey();
            if (fileName.endsWith(".properties")) {
                ctrl = aggregate.get(fileName);
                if (ctrl != null) {
                    Properties childMap = ProfileImpl.toProperties(entry.getValue());
                    if (childMap.remove("#deleted#") != null) {
                        ctrl.props.clear();
                    }
                    for (Map.Entry<Object, Object> p : childMap.entrySet()) {
                        if ("#deleted#".equals(p.getValue())) {
                            ctrl.props.remove(p.getKey());
                            continue;
                        }
                        ctrl.props.put(p.getKey(), p.getValue());
                    }
                    continue;
                }
                ctrl = new SupplementControl();
                ctrl.props = ProfileImpl.toProperties(entry.getValue());
                aggregate.put(fileName, ctrl);
                continue;
            }
            ctrl = new SupplementControl();
            ctrl.data = entry.getValue();
            aggregate.put(fileName, ctrl);
        }
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        try {
            HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
            this.supplement(this.self, aggregate);
            HashMap<String, Map<String, String>> rc = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : aggregate.entrySet()) {
                SupplementControl ctrl = (SupplementControl)entry.getValue();
                if (ctrl.props == null) continue;
                rc.put(ProfileImpl.stripSuffix((String)entry.getKey(), ".properties"), ProfileImpl.toMap(ctrl.props));
            }
            return rc;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isAbstract() {
        return this.self.isAbstract();
    }

    private static class SupplementControl {
        byte[] data;
        Properties props;

        private SupplementControl() {
        }
    }
}

