/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.maven.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.fusesource.fabric.maven.MavenProxy;
import org.fusesource.fabric.maven.MavenProxyUtils;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Deprecated
public class MavenProxyImpl
implements MavenProxy {
    private static final Logger LOGGER = Logger.getLogger(MavenProxyImpl.class.getName());
    private int port = 8040;
    private String localRepository;
    private String remoteRepositories = "repo1.maven.org/maven2,repo.fusesource.com/nexus/content/groups/public,repo.fusesource.com/nexus/content/groups/public-snapshots,repo.fusesource.com/nexus/content/groups/ea";
    private String updatePolicy;
    private String checksumPolicy;
    private List<RemoteRepository> repositories;
    private ServerSocket serverSocket;
    private RepositorySystem system;
    private RepositorySystemSession session;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public String getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(String remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public void setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
    }

    public synchronized URI getAddress() {
        if (this.serverSocket != null) {
            return URI.create(MavenProxyUtils.getMavenProxyUrl(this.port));
        }
        return null;
    }

    public synchronized boolean isStarted() {
        return this.serverSocket != null;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.port >= 0) {
            if (this.localRepository.equals("")) {
                this.localRepository = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
            }
            if (this.system == null) {
                this.system = this.newRepositorySystem();
            }
            if (this.session == null) {
                this.session = this.newSession(this.system, this.localRepository);
            }
            this.repositories = new ArrayList<RemoteRepository>();
            this.repositories.add(new RemoteRepository("local", "default", "file://" + this.localRepository));
            int i = 0;
            for (String rep : this.remoteRepositories.split(",")) {
                RemoteRepository remoteRepository = new RemoteRepository("repo-" + i++, "default", rep);
                remoteRepository.setPolicy(true, new RepositoryPolicy(true, this.updatePolicy, this.checksumPolicy));
                this.repositories.add(remoteRepository);
            }
            String repos = "local:" + this.localRepository + " ";
            for (RemoteRepository repo : this.repositories) {
                repos = repos + repo + " ";
            }
            repos = repos.trim();
            this.serverSocket = new ServerSocket(this.port);
            Acceptor acceptor = new Acceptor(this.serverSocket);
            acceptor.setName("MavenProxyAcceptor");
            acceptor.start();
            LOGGER.log(Level.INFO, String.format("Maven proxy started at address : %s with configured repositories : %s", this.getAddress(), repos));
        }
    }

    @Override
    public synchronized void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.serverSocket = null;
            }
        }
    }

    @Override
    public File download(String path) {
        return null;
    }

    @Override
    public boolean upload(InputStream is, String path) {
        return false;
    }

    private RepositorySystemSession newSession(RepositorySystem system, String localRepository) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, new ManualWagonProvider());
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setService(org.sonatype.aether.spi.log.Logger.class, LogAdapter.class);
        return locator.getService(RepositorySystem.class);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String convertToMavenUrl(String location) {
        String[] p = location.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String classifier;
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuffer sb = new StringBuffer();
            if (p[p.length - 1].charAt(artifactIdVersion.length()) == '-') {
                classifier = p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46));
                artifactIdVersion = artifactIdVersion + "-" + classifier;
            } else {
                classifier = "";
            }
            String type = p[p.length - 1].substring(artifactIdVersion.length() + 1);
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append(':').append(artifactId).append(':').append(type);
            if (classifier.length() > 0) {
                sb.append(":").append(classifier);
            }
            sb.append(":").append(version);
            return sb.toString();
        }
        return null;
    }

    public static class LogAdapter
    implements org.sonatype.aether.spi.log.Logger {
        @Override
        public boolean isDebugEnabled() {
            return LOGGER.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            LOGGER.log(Level.FINE, msg);
        }

        @Override
        public void debug(String msg, Throwable error) {
            LOGGER.log(Level.FINE, msg, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return LOGGER.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String msg) {
            LOGGER.log(Level.WARNING, msg);
        }

        @Override
        public void warn(String msg, Throwable error) {
            LOGGER.log(Level.WARNING, msg, error);
        }
    }

    public static class ManualWagonProvider
    implements WagonProvider {
        @Override
        public Wagon lookup(String roleHint) throws Exception {
            if ("file".equals(roleHint)) {
                return new FileWagon();
            }
            if ("http".equals(roleHint)) {
                return new LightweightHttpWagon();
            }
            return null;
        }

        @Override
        public void release(Wagon wagon) {
        }
    }

    protected class Worker
    extends Thread {
        private final Socket socket;

        public Worker(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String mvn;
            BufferedOutputStream output;
            FileInputStream inputStream;
            block12: {
                String headLine;
                block11: {
                    inputStream = null;
                    output = null;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    output = new BufferedOutputStream(this.socket.getOutputStream());
                    headLine = reader.readLine();
                    if (headLine != null && headLine.startsWith("GET ") && (headLine.endsWith(" HTTP/1.0") || headLine.endsWith(" HTTP/1.1"))) break block11;
                    LOGGER.log(Level.WARNING, String.format("Received invalid method : %s", headLine));
                    output.write("HTTP/1.0 405 Invalid method.\r\n\r\n".getBytes());
                    MavenProxyImpl.close(new Closeable[]{inputStream, output});
                    return;
                }
                String path = headLine.substring(4, headLine.length() - 9);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((mvn = MavenProxyImpl.convertToMavenUrl(path)) != null) break block12;
                LOGGER.log(Level.WARNING, String.format("Received non maven request : %s", path));
                output.write("HTTP/1.0 404 File not found.\r\n\r\n".getBytes());
                MavenProxyImpl.close(new Closeable[]{inputStream, output});
                return;
            }
            LOGGER.log(Level.INFO, String.format("Received request for file : %s", mvn));
            try {
                DefaultArtifact artifact = new DefaultArtifact(mvn, null);
                ArtifactRequest request = new ArtifactRequest(artifact, MavenProxyImpl.this.repositories, null);
                ArtifactResult result = MavenProxyImpl.this.system.resolveArtifact(MavenProxyImpl.this.session, request);
                inputStream = new FileInputStream(result.getArtifact().getFile());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Could not find file : %s due to %s", mvn, e));
                output.write("HTTP/1.0 404 File not found.\r\n\r\n".getBytes());
                MavenProxyImpl.close(new Closeable[]{inputStream, output});
                return;
            }
            try {
                int length;
                LOGGER.log(Level.INFO, String.format("Writing response for file : %s", mvn));
                output.write(("HTTP/1.1 200 OK\r\nDate: " + new Date().toString() + "\r\n" + "Server: FON Proxy/" + "1.0-SNAPSHOT" + "\r\n" + "Connection: close\r\n" + "Content-Type: application/octet-stream\r\n" + "Content-Length: " + ((InputStream)inputStream).available() + "\r\n" + "\r\n").getBytes());
                byte[] buffer = new byte[4096];
                while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
                output.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.log(Level.SEVERE, "Exception caught in maven proxy", e);
                }
                catch (Throwable throwable) {
                    MavenProxyImpl.close(new Closeable[]{inputStream, output});
                    throw throwable;
                }
                MavenProxyImpl.close(new Closeable[]{inputStream, output});
            }
            MavenProxyImpl.close(new Closeable[]{inputStream, output});
        }
    }

    protected class Acceptor
    extends Thread {
        private final ServerSocket serverSocket;

        public Acceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (!this.serverSocket.isClosed()) {
                        Socket sock = this.serverSocket.accept();
                        Worker worker = new Worker(sock);
                        worker.setName("MavenProxyWorker");
                        worker.start();
                    }
                }
                catch (IOException e) {
                    if (this.serverSocket.isClosed()) break block3;
                    LOGGER.log(Level.SEVERE, "Exception caught in maven proxy", e);
                }
            }
        }
    }
}

