/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.tracker;

import org.apache.zookeeper.data.Stat;
import org.linkedin.util.annotations.Initializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackedNode<T> {
    private String _path;
    private T _data;
    private Stat _stat;
    private int _depth;

    public TrackedNode() {
    }

    public TrackedNode(String path, T data, Stat stat, int depth) {
        this._data = data;
        this._depth = depth;
        this._path = path;
        this._stat = stat;
    }

    public T getData() {
        return this._data;
    }

    @Initializer(required=true)
    public void setData(T data) {
        this._data = data;
    }

    public int getDepth() {
        return this._depth;
    }

    @Initializer(required=true)
    public void setDepth(int depth) {
        this._depth = depth;
    }

    public String getPath() {
        return this._path;
    }

    @Initializer(required=true)
    public void setPath(String path) {
        this._path = path;
    }

    public Stat getStat() {
        return this._stat;
    }

    @Initializer(required=true)
    public void setStat(Stat stat) {
        this._stat = stat;
    }

    public long getCreationTime() {
        return this._stat.getCtime();
    }

    public long getModifiedTime() {
        return this._stat.getMtime();
    }

    public long getZkTxId() {
        return Math.max(this._stat.getMzxid(), this._stat.getPzxid());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{path:'").append(this.getPath()).append("',");
        sb.append("zktxid:").append(this.getZkTxId()).append(",");
        sb.append("stat:'").append(this.getStat().toString().trim()).append("',");
        sb.append("data:'").append(this.getData()).append("'}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackedNode that = (TrackedNode)o;
        if (this._depth != that._depth) {
            return false;
        }
        if (this._data != null ? !this._data.equals(that._data) : that._data != null) {
            return false;
        }
        if (this._path != null ? !this._path.equals(that._path) : that._path != null) {
            return false;
        }
        return !(this._stat != null ? !this._stat.equals(that._stat) : that._stat != null);
    }

    public int hashCode() {
        int result = this._path != null ? this._path.hashCode() : 0;
        result = 31 * result + (this._stat != null ? this._stat.hashCode() : 0);
        result = 31 * result + (this._data != null ? this._data.hashCode() : 0);
        result = 31 * result + this._depth;
        return result;
    }
}

