/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.clock;

import org.linkedin.util.clock.BaseClock;
import org.linkedin.util.clock.Timespan;

public class SettableClock
extends BaseClock {
    private static final long serialVersionUID = 1L;
    private long _currentTimeMillis;
    private long _checkpointedCurrentTimeMillis = -1L;

    public SettableClock() {
        this(System.currentTimeMillis());
    }

    public SettableClock(long currentTimeMillis) {
        this.setCurrentTimeMillis(currentTimeMillis);
    }

    @Override
    public long currentTimeMillis() {
        return this._currentTimeMillis;
    }

    public void setCurrentTimeMillis(long currentTimeMillis) {
        this._currentTimeMillis = currentTimeMillis;
    }

    public void addDuration(Timespan duration) {
        this.setCurrentTimeMillis(duration.futureTimeMillis(this));
    }

    public void subtractDuration(Timespan duration) {
        this.setCurrentTimeMillis(duration.pastTimeMillis(this));
    }

    public void checkpoint() {
        this._checkpointedCurrentTimeMillis = this._currentTimeMillis;
    }

    public long revertToCheckpoint() {
        if (this._checkpointedCurrentTimeMillis != -1L) {
            this._currentTimeMillis = this._checkpointedCurrentTimeMillis;
            this._checkpointedCurrentTimeMillis = -1L;
        }
        return this._currentTimeMillis;
    }
}

