/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.list.MBeanInfoData;
import org.jolokia.request.JmxListRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHandler
extends JsonRequestHandler<JmxListRequest> {
    @Override
    public RequestType getType() {
        return RequestType.LIST;
    }

    public ListHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public boolean handleAllServersAtOnce(JmxListRequest pRequest) {
        return true;
    }

    @Override
    protected void checkForRestriction(JmxListRequest pRequest) {
        this.checkType();
    }

    @Override
    public Object doHandleRequest(Set<MBeanServerConnection> pServers, JmxListRequest pRequest) throws InstanceNotFoundException, IOException {
        Stack<String> originalPathStack = EscapeUtil.reversePath(pRequest.getPathParts());
        int maxDepth = this.getMaxDepth(pRequest);
        boolean useCanonicalName = pRequest.getProcessingConfigAsBoolean(ConfigKey.CANONICAL_NAMING);
        ObjectName oName = null;
        try {
            Stack pathStack = (Stack)originalPathStack.clone();
            MBeanInfoData infoMap = new MBeanInfoData(maxDepth, pathStack, useCanonicalName);
            oName = this.objectNameFromPath(pathStack);
            if (oName == null || oName.isPattern()) {
                this.addMBeansFromPattern(infoMap, pServers, oName);
            } else {
                this.addSingleMBean(infoMap, pServers, oName);
            }
            return infoMap.truncate();
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid path within the MBean part given. (Path: " + pRequest.getPath() + ")", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("Invalid object name '" + oName + "': Instance not found", e);
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection server, JmxListRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }

    @Override
    public boolean useReturnValueWithPath() {
        return false;
    }

    private void addMBeansFromPattern(MBeanInfoData pInfoMap, Set<MBeanServerConnection> pServers, ObjectName pPattern) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        for (MBeanServerConnection server : pServers) {
            for (ObjectName nameObject : server.queryNames(pPattern, null)) {
                ObjectName name = nameObject;
                if (pInfoMap.handleFirstOrSecondLevel(name)) continue;
                this.addMBeanInfo(pInfoMap, server, name);
            }
        }
    }

    private void addSingleMBean(MBeanInfoData pInfomap, Set<MBeanServerConnection> pServers, ObjectName pName) throws IntrospectionException, ReflectionException, IOException, InstanceNotFoundException {
        if (!pInfomap.handleFirstOrSecondLevel(pName)) {
            InstanceNotFoundException instanceNotFound = null;
            for (MBeanServerConnection server : pServers) {
                try {
                    this.addMBeanInfo(pInfomap, server, pName);
                    return;
                }
                catch (InstanceNotFoundException exp) {
                    instanceNotFound = exp;
                }
            }
            if (instanceNotFound != null) {
                throw instanceNotFound;
            }
        }
    }

    private void addMBeanInfo(MBeanInfoData pInfoMap, MBeanServerConnection server, ObjectName pName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            MBeanInfo mBeanInfo = server.getMBeanInfo(pName);
            pInfoMap.addMBeanInfo(mBeanInfo, pName);
        }
        catch (IOException exp) {
            pInfoMap.handleException(pName, exp);
        }
        catch (IllegalStateException exp) {
            pInfoMap.handleException(pName, exp);
        }
    }

    private int getMaxDepth(JmxListRequest pRequest) {
        Integer maxDepthI = pRequest.getProcessingConfigAsInt(ConfigKey.MAX_DEPTH);
        return maxDepthI == null ? 0 : maxDepthI;
    }

    private ObjectName objectNameFromPath(Stack<String> pPathStack) throws MalformedObjectNameException {
        if (pPathStack.empty()) {
            return null;
        }
        Stack path = (Stack)pPathStack.clone();
        String domain = (String)path.pop();
        if (path.empty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)path.pop();
        ObjectName mbean = new ObjectName(domain + ":" + props);
        if (mbean.isPattern()) {
            throw new IllegalArgumentException("Cannot use an MBean pattern as path (given MBean: " + mbean + ")");
        }
        return mbean;
    }
}

