/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataExtractor
implements Extractor {
    @Override
    public Class getType() {
        return CompositeData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        CompositeData cd = (CompositeData)pValue;
        if (!pExtraArgs.isEmpty()) {
            String key = pExtraArgs.pop();
            try {
                return pConverter.extractObject(cd.get(key), pExtraArgs, jsonify);
            }
            catch (InvalidKeyException exp) {
                throw new AttributeNotFoundException("Invalid path '" + key + "'");
            }
        }
        if (jsonify) {
            JSONObject ret = new JSONObject();
            for (String key : cd.getCompositeType().keySet()) {
                ret.put(key, pConverter.extractObject(cd.get(key), pExtraArgs, jsonify));
            }
            return ret;
        }
        return cd;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("CompositeData cannot be written to");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

