/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeans {
    private static final Log LOG = LogFactory.getLog(MBeans.class);

    public static ObjectName register(String serviceName, String nameName, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = MBeans.getMBeanName(serviceName, nameName);
        try {
            mbs.registerMBean(theMbean, name);
            return name;
        }
        catch (InstanceAlreadyExistsException ie) {
            LOG.warn((Object)name, (Throwable)ie);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error registering " + name), (Throwable)e);
        }
        return null;
    }

    public static void unregister(ObjectName mbeanName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (InstanceNotFoundException e) {
            LOG.warn((Object)mbeanName, (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error unregistering " + mbeanName), (Throwable)e);
        }
    }

    private static ObjectName getMBeanName(String serviceName, String nameName) {
        ObjectName name = null;
        String nameStr = "org.apache.hadoop:service=" + serviceName + ",name=" + nameName;
        try {
            name = new ObjectName(nameStr);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)("Error creating MBean object name: " + nameStr), (Throwable)e);
        }
        return name;
    }
}

