/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.commands;

import java.io.File;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.fusesource.fabric.hadoop.commands.HadoopCommandSupport;

@Command(name="namenode-format", scope="hadoop", description="Format a HDFS volume")
public class NameNodeFormat
extends HadoopCommandSupport {
    @Option(name="--force")
    boolean force;

    @Override
    protected void doExecute(Configuration conf) throws Exception {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        for (File curDir : dirsToFormat) {
            if (!curDir.exists() || this.force) continue;
            System.err.print("Re-format filesystem in " + curDir + " ? (Y or N) ");
            System.err.flush();
            if (System.in.read() != 89) {
                System.err.println("Format aborted in " + curDir);
                return;
            }
            while (System.in.read() != 10) {
            }
        }
        NameNode.format(conf);
    }
}

