/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.mapred;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.Daemon;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class TaskTrackerFactory
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, TaskTracker> taskTrackers = new HashMap<String, TaskTracker>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "MapRed JobTracker factory";
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.deleted(pid);
            JobConf conf = new JobConf();
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = properties.get(key);
                conf.set(key.toString(), val.toString());
            }
            TaskTracker taskTracker = new TaskTracker(conf);
            new Daemon(taskTracker).start();
            this.taskTrackers.put(pid, taskTracker);
            this.services.put(pid, this.bundleContext.registerService(TaskTracker.class.getName(), (Object)taskTracker, properties));
        }
        catch (Exception e) {
            throw (ConfigurationException)new ConfigurationException(null, "Unable to parse HDFS configuration: " + e.getMessage()).initCause((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public synchronized void deleted(String pid) {
        TaskTracker taskTracker = this.taskTrackers.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
        if (taskTracker != null) {
            try {
                taskTracker.shutdown();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        while (!this.taskTrackers.isEmpty()) {
            String pid = this.taskTrackers.keySet().iterator().next();
            this.deleted(pid);
        }
    }
}

