/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.commands;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.hadoop.util.Tool;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class HadoopCommand
extends AbstractCommand
implements Function,
CompletableFunction {
    Class tool;
    protected Map<String, Completer> optionalCompleters;

    public Class getTool() {
        return this.tool;
    }

    public void setTool(Class tool) {
        this.tool = tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandSession commandSession, List<Object> objects) throws Exception {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.doExecute(objects);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
        return null;
    }

    protected void doExecute(List<Object> objects) throws Exception {
        Tool run;
        org.apache.hadoop.conf.Configuration conf = this.getConfiguration();
        try {
            Constructor cns = this.tool.getDeclaredConstructor(new Class[0]);
            cns.setAccessible(true);
            run = (Tool)cns.newInstance(new Object[0]);
            run.setConf(conf);
        }
        catch (NoSuchMethodException e) {
            Constructor cns = this.tool.getDeclaredConstructor(org.apache.hadoop.conf.Configuration.class);
            cns.setAccessible(true);
            run = (Tool)cns.newInstance(conf);
        }
        String[] args = new String[objects.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = objects.get(i) != null ? objects.get(i).toString() : null;
        }
        run.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.hadoop.conf.Configuration getConfiguration() throws IOException {
        BundleContext bc = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference ref = bc.getServiceReference(ConfigurationAdmin.class.getName());
        try {
            Dictionary dictionary;
            ConfigurationAdmin admin = ref != null ? (ConfigurationAdmin)bc.getService(ref) : null;
            Configuration config = admin != null ? admin.getConfiguration("org.fusesource.fabric.hadoop") : null;
            Dictionary dictionary2 = dictionary = config != null ? config.getProperties() : null;
            if (dictionary == null) {
                throw new IllegalStateException("No configuration found for pid org.fusesource.fabric.hadoop");
            }
            org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = dictionary.get(key);
                conf.set(key.toString(), val.toString());
            }
            org.apache.hadoop.conf.Configuration configuration = conf;
            return configuration;
        }
        finally {
            if (ref != null) {
                bc.ungetService(ref);
            }
        }
    }

    public List<Completer> getCompleters() {
        return null;
    }

    public Class<? extends Action> getActionClass() {
        return this.tool;
    }

    public Action createNewAction() {
        return null;
    }

    public void setOptionalCompleters(Map<String, Completer> optionalCompleters) {
        this.optionalCompleters = optionalCompleters;
    }

    public Map<String, Completer> getOptionalCompleters() {
        return this.optionalCompleters;
    }
}

