/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.SingleEventEmitter;

abstract class HistoryEventEmitter {
    private static final Log LOG = LogFactory.getLog(HistoryEventEmitter.class);

    abstract List<SingleEventEmitter> nonFinalSEEs();

    abstract List<SingleEventEmitter> finalSEEs();

    protected HistoryEventEmitter() {
    }

    final Pair<Queue<HistoryEvent>, PostEmitAction> emitterCore(ParsedLine line, String name) {
        HistoryEvent event;
        LinkedList<HistoryEvent> results = new LinkedList<HistoryEvent>();
        PostEmitAction removeEmitter = PostEmitAction.NONE;
        for (SingleEventEmitter see : this.nonFinalSEEs()) {
            event = see.maybeEmitEvent(line, name, this);
            if (event == null) continue;
            results.add(event);
        }
        for (SingleEventEmitter see : this.finalSEEs()) {
            event = see.maybeEmitEvent(line, name, this);
            if (event == null) continue;
            results.add(event);
            removeEmitter = PostEmitAction.REMOVE_HEE;
            break;
        }
        return new Pair<Queue<HistoryEvent>, PostEmitAction>(results, removeEmitter);
    }

    protected static Counters maybeParseCounters(String counters) {
        try {
            return HistoryEventEmitter.parseCounters(counters);
        }
        catch (ParseException e) {
            LOG.warn((Object)("The counter string, \"" + counters + "\" is badly formatted."));
            return null;
        }
    }

    protected static Counters parseCounters(String counters) throws ParseException {
        if (counters == null) {
            LOG.warn((Object)"HistoryEventEmitters: null counter detected:");
            return null;
        }
        counters = counters.replace("\\.", "\\\\.");
        counters = counters.replace("\\\\(", "\\(");
        counters = counters.replace("\\\\)", "\\)");
        counters = counters.replace("\\\\[", "\\[");
        counters = counters.replace("\\\\]", "\\]");
        org.apache.hadoop.mapred.Counters depForm = org.apache.hadoop.mapred.Counters.fromEscapedCompactString(counters);
        return new Counters(depForm);
    }

    static enum PostEmitAction {
        NONE,
        REMOVE_HEE;

    }
}

