/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.mapred;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class JobTrackerFactory
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, JobTracker> jobTrackers = new HashMap<String, JobTracker>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "MapRed JobTracker factory";
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.deleted(pid);
            JobConf conf = new JobConf();
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = properties.get(key);
                conf.set(key.toString(), val.toString());
            }
            JobTracker jobTracker = JobTracker.startTracker(conf);
            jobTracker.offerService();
            this.jobTrackers.put(pid, jobTracker);
            this.services.put(pid, this.bundleContext.registerService(JobTracker.class.getName(), (Object)jobTracker, properties));
        }
        catch (Exception e) {
            throw (ConfigurationException)new ConfigurationException(null, "Unable to parse HDFS configuration: " + e.getMessage()).initCause((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public synchronized void deleted(String pid) {
        JobTracker jobTracker = this.jobTrackers.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
        if (jobTracker != null) {
            try {
                jobTracker.stopTracker();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        while (!this.jobTrackers.isEmpty()) {
            String pid = this.jobTrackers.keySet().iterator().next();
            this.deleted(pid);
        }
    }
}

