/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.hdfs;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.util.Daemon;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class SecondaryNameNodeFactory
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, SecondaryNameNode> secondaryNameNodes = new HashMap<String, SecondaryNameNode>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "HDFS NodeName factory";
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.deleted(pid);
            Configuration conf = new Configuration();
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = properties.get(key);
                conf.set(key.toString(), val.toString());
            }
            SecondaryNameNode secondaryNameNode = new SecondaryNameNode(conf);
            Daemon checkpointThread = new Daemon(secondaryNameNode);
            checkpointThread.start();
            this.secondaryNameNodes.put(pid, secondaryNameNode);
            this.services.put(pid, this.bundleContext.registerService(NameNode.class.getName(), (Object)secondaryNameNode, properties));
        }
        catch (Exception e) {
            throw (ConfigurationException)new ConfigurationException(null, "Unable to parse HDFS configuration: " + e.getMessage()).initCause((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public synchronized void deleted(String pid) {
        SecondaryNameNode secondaryNameNode = this.secondaryNameNodes.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
        if (secondaryNameNode != null) {
            secondaryNameNode.shutdown();
        }
    }

    public void destroy() {
        while (!this.secondaryNameNodes.isEmpty()) {
            String pid = this.secondaryNameNodes.keySet().iterator().next();
            this.deleted(pid);
        }
    }
}

