/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop.hdfs;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class NameNodeFactory
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, NameNode> nameNodes = new HashMap<String, NameNode>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "HDFS NodeName factory";
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.deleted(pid);
            Configuration conf = new Configuration();
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = properties.get(key);
                conf.set(key.toString(), val.toString());
            }
            boolean exists = false;
            for (File file : FSNamesystem.getNamespaceDirs(conf)) {
                exists |= file.exists();
            }
            if (!exists) {
                NameNode.format(conf);
            }
            NameNode nameNode = NameNode.createNameNode(null, conf);
            this.nameNodes.put(pid, nameNode);
            this.services.put(pid, this.bundleContext.registerService(NameNode.class.getName(), (Object)nameNode, properties));
        }
        catch (Exception e) {
            throw (ConfigurationException)new ConfigurationException(null, "Unable to parse HDFS configuration: " + e.getMessage()).initCause((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public synchronized void deleted(String pid) {
        NameNode nameNode = this.nameNodes.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
        if (nameNode != null) {
            nameNode.stop();
        }
    }

    public void destroy() {
        while (!this.nameNodes.isEmpty()) {
            String pid = this.nameNodes.keySet().iterator().next();
            this.deleted(pid);
        }
    }
}

