/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.hadoop;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.fusesource.fabric.hadoop.hdfs.DataNodeFactory;
import org.fusesource.fabric.hadoop.hdfs.NameNodeFactory;
import org.fusesource.fabric.hadoop.hdfs.SecondaryNameNodeFactory;
import org.fusesource.fabric.hadoop.mapred.JobTrackerFactory;
import org.fusesource.fabric.hadoop.mapred.TaskTrackerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public class HadoopFactory
implements ManagedService {
    public static final String CONFIG_PID = "org.fusesource.fabric.hadoop";
    private BundleContext bundleContext;
    private DataNodeFactory dataNodeFactory;
    private NameNodeFactory nameNodeFactory;
    private SecondaryNameNodeFactory secondaryNameNodeFactory;
    private JobTrackerFactory jobTrackerFactory;
    private TaskTrackerFactory taskTrackerFactory;
    private Set<String> nameNodes = new HashSet<String>();
    private Set<String> dataNodes = new HashSet<String>();
    private Set<String> secondaryNameNodes = new HashSet<String>();
    private Set<String> jobTrackers = new HashSet<String>();
    private Set<String> taskTrackers = new HashSet<String>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DataNodeFactory getDataNodeFactory() {
        return this.dataNodeFactory;
    }

    public void setDataNodeFactory(DataNodeFactory dataNodeFactory) {
        this.dataNodeFactory = dataNodeFactory;
    }

    public NameNodeFactory getNameNodeFactory() {
        return this.nameNodeFactory;
    }

    public void setNameNodeFactory(NameNodeFactory nameNodeFactory) {
        this.nameNodeFactory = nameNodeFactory;
    }

    public SecondaryNameNodeFactory getSecondaryNameNodeFactory() {
        return this.secondaryNameNodeFactory;
    }

    public void setSecondaryNameNodeFactory(SecondaryNameNodeFactory secondaryNameNodeFactory) {
        this.secondaryNameNodeFactory = secondaryNameNodeFactory;
    }

    public JobTrackerFactory getJobTrackerFactory() {
        return this.jobTrackerFactory;
    }

    public void setJobTrackerFactory(JobTrackerFactory jobTrackerFactory) {
        this.jobTrackerFactory = jobTrackerFactory;
    }

    public TaskTrackerFactory getTaskTrackerFactory() {
        return this.taskTrackerFactory;
    }

    public void setTaskTrackerFactory(TaskTrackerFactory taskTrackerFactory) {
        this.taskTrackerFactory = taskTrackerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary properties) throws ConfigurationException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (properties == null) {
                this.deleted(this.getClass().getName());
            } else {
                this.updated(this.getClass().getName(), properties);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.updateFactory(pid, properties, "nameNode", this.nameNodes, this.nameNodeFactory);
        this.updateFactory(pid, properties, "dataNode", this.dataNodes, this.dataNodeFactory);
        this.updateFactory(pid, properties, "secondaryNameNode", this.secondaryNameNodes, this.secondaryNameNodeFactory);
        this.updateFactory(pid, properties, "jobTracker", this.jobTrackers, this.jobTrackerFactory);
        this.updateFactory(pid, properties, "taskTracker", this.taskTrackers, this.taskTrackerFactory);
    }

    private void updateFactory(String pid, Dictionary properties, String prop, Set<String> set, ManagedServiceFactory factory) throws ConfigurationException {
        if (this.getBool(properties.get(prop), false)) {
            set.add(pid);
            factory.updated(pid, properties);
        } else if (set.remove(pid)) {
            factory.deleted(pid);
        }
    }

    public void deleted(String pid) {
        this.deleteFactory(pid, this.nameNodes, this.nameNodeFactory);
    }

    private void deleteFactory(String pid, Set<String> set, ManagedServiceFactory factory) {
        if (set.remove(pid)) {
            factory.deleted(pid);
        }
    }

    public void destroy() throws ConfigurationException {
        this.updated(null);
    }

    private boolean getBool(Object val, boolean def) {
        if (val != null) {
            return Boolean.parseBoolean(val.toString());
        }
        return def;
    }
}

