/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.tools.rumen.DefaultInputDemuxer;
import org.apache.hadoop.tools.rumen.DefaultOutputter;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.InputDemuxer;
import org.apache.hadoop.tools.rumen.JobBuilder;
import org.apache.hadoop.tools.rumen.JobConfPropertyNames;
import org.apache.hadoop.tools.rumen.JobConfigurationParser;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.JobHistoryParserFactory;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.Outputter;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.RewindableInputStream;
import org.apache.hadoop.tools.rumen.TopologyBuilder;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TraceBuilder
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TraceBuilder.class);
    static final int RUN_METHOD_FAILED_EXIT_CODE = 3;
    TopologyBuilder topologyBuilder = new TopologyBuilder();
    JobConfigurationParser jobConfParser;
    Outputter<LoggedJob> traceWriter;
    Outputter<LoggedNetworkTopology> topologyWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TraceBuilder builder = new TraceBuilder();
        int result = 3;
        try {
            result = ToolRunner.run(builder, args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            try {
                builder.finish();
            }
            finally {
                if (result == 0) {
                    return;
                }
                System.exit(result);
            }
        }
    }

    private static String applyParser(String fileName, Pattern pattern) {
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    static String extractJobID(String fileName) {
        String jobId = TraceBuilder.applyParser(fileName, JobHistory.JOBHISTORY_FILENAME_REGEX);
        if (jobId == null) {
            jobId = TraceBuilder.applyParser(fileName, Pre21JobHistoryConstants.JOBHISTORY_FILENAME_REGEX);
        }
        return jobId;
    }

    static boolean isJobConfXml(String fileName, InputStream input) {
        String jobId = TraceBuilder.applyParser(fileName, JobHistory.CONF_FILENAME_REGEX);
        if (jobId == null) {
            jobId = TraceBuilder.applyParser(fileName, Pre21JobHistoryConstants.CONF_FILENAME_REGEX);
        }
        return jobId != null;
    }

    private void addInterestedProperties(List<String> interestedProperties, String[] names) {
        for (String name : names) {
            interestedProperties.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int run(String[] args) throws Exception {
        MyOptions options = new MyOptions(args, this.getConf());
        ArrayList<String> interestedProperties = new ArrayList<String>();
        for (JobConfPropertyNames candidateSet : JobConfPropertyNames.values()) {
            this.addInterestedProperties(interestedProperties, candidateSet.getCandidates());
        }
        this.jobConfParser = new JobConfigurationParser(interestedProperties);
        this.traceWriter = options.clazzTraceOutputter.newInstance();
        this.traceWriter.init(options.traceOutput, this.getConf());
        this.topologyWriter = new DefaultOutputter<LoggedNetworkTopology>();
        this.topologyWriter.init(options.topologyOutput, this.getConf());
        try {
            JobBuilder jobBuilder = null;
            for (Path p : options.inputs) {
                InputDemuxer inputDemuxer = options.inputDemuxerClass.newInstance();
                try {
                    inputDemuxer.bindTo(p, this.getConf());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to bind Path " + p + " .  Skipping..."), (Throwable)e);
                    continue;
                }
                Pair<String, InputStream> filePair = null;
                try {
                    while ((filePair = inputDemuxer.getNext()) != null) {
                        RewindableInputStream ris = new RewindableInputStream(filePair.second());
                        Closeable parser = null;
                        try {
                            String jobID = TraceBuilder.extractJobID(filePair.first());
                            if (jobID == null) {
                                LOG.warn((Object)("File skipped: Invalid file name: " + filePair.first()));
                                continue;
                            }
                            if (jobBuilder == null || !jobBuilder.getJobID().equals(jobID)) {
                                if (jobBuilder != null) {
                                    this.traceWriter.output(jobBuilder.build());
                                }
                                jobBuilder = new JobBuilder(jobID);
                            }
                            if (TraceBuilder.isJobConfXml(filePair.first(), ris)) {
                                this.processJobConf(this.jobConfParser.parse(ris.rewind()), jobBuilder);
                                continue;
                            }
                            parser = JobHistoryParserFactory.getParser(ris);
                            if (parser == null) {
                                LOG.warn((Object)("File skipped: Cannot find suitable parser: " + filePair.first()));
                                continue;
                            }
                            this.processJobHistory((JobHistoryParser)parser, jobBuilder);
                        }
                        finally {
                            if (parser == null) {
                                ris.close();
                                continue;
                            }
                            parser.close();
                            parser = null;
                        }
                    }
                }
                catch (Throwable t) {
                    if (filePair == null) continue;
                    LOG.warn((Object)("TraceBuilder got an error while processing the [possibly virtual] file " + filePair.first() + " within Path " + p), t);
                }
                finally {
                    inputDemuxer.close();
                }
            }
            if (jobBuilder != null) {
                this.traceWriter.output(jobBuilder.build());
                jobBuilder = null;
            } else {
                LOG.warn((Object)"No job found in traces: ");
            }
            this.topologyWriter.output(this.topologyBuilder.build());
            return 0;
        }
        finally {
            this.traceWriter.close();
            this.topologyWriter.close();
        }
    }

    private void processJobConf(Properties properties, JobBuilder jobBuilder) {
        jobBuilder.process(properties);
        this.topologyBuilder.process(properties);
    }

    void processJobHistory(JobHistoryParser parser, JobBuilder jobBuilder) throws IOException {
        HistoryEvent e;
        while ((e = parser.nextEvent()) != null) {
            jobBuilder.process(e);
            this.topologyBuilder.process(e);
        }
        parser.close();
    }

    void finish() {
        IOUtils.cleanup(LOG, this.traceWriter, this.topologyWriter);
    }

    static class MyOptions {
        Class<? extends InputDemuxer> inputDemuxerClass = DefaultInputDemuxer.class;
        Class<? extends Outputter> clazzTraceOutputter = DefaultOutputter.class;
        Path traceOutput;
        Path topologyOutput;
        List<Path> inputs = new LinkedList<Path>();

        MyOptions(String[] args, Configuration conf) throws FileNotFoundException, IOException, ClassNotFoundException {
            int switchTop = 0;
            while (args[switchTop].startsWith("-")) {
                if (!args[switchTop].equalsIgnoreCase("-demuxer")) continue;
                this.inputDemuxerClass = Class.forName(args[++switchTop]).asSubclass(InputDemuxer.class);
                ++switchTop;
            }
            this.traceOutput = new Path(args[0 + switchTop]);
            this.topologyOutput = new Path(args[1 + switchTop]);
            for (int i = 2 + switchTop; i < args.length; ++i) {
                Path thisPath = new Path(args[i]);
                FileSystem fs = thisPath.getFileSystem(conf);
                if (fs.getFileStatus(thisPath).isDir()) {
                    FileStatus[] statuses = fs.listStatus(thisPath);
                    ArrayList<String> dirNames = new ArrayList<String>();
                    for (FileStatus s : statuses) {
                        String name;
                        if (s.isDir() || (name = s.getPath().getName()).endsWith(".crc") || name.startsWith(".")) continue;
                        dirNames.add(name);
                    }
                    Object[] sortableNames = dirNames.toArray(new String[1]);
                    Arrays.sort(sortableNames);
                    for (Object dirName : sortableNames) {
                        this.inputs.add(new Path(thisPath, (String)dirName));
                    }
                    continue;
                }
                this.inputs.add(thisPath);
            }
        }
    }
}

