/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.demo.activemq;

import java.util.Dictionary;
import javax.jms.JMSException;
import org.fusesource.fabric.demo.activemq.ActiveMQProducerFactory;
import org.fusesource.mq.ActiveMQService;
import org.fusesource.mq.ConsumerThread;
import org.fusesource.mq.JMSService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConsumerFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQProducerFactory.class);
    ConsumerThread consumer;
    ActiveMQService consumerService;

    public String getName() {
        return "ActiveMQ Consumer Factory";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            String brokerUrl = (String)properties.get("brokerUrl");
            if (brokerUrl == null) {
                brokerUrl = "discover:(fabric:default)";
            }
            this.consumerService = new ActiveMQService(brokerUrl);
            this.consumerService.setMaxAttempts(10);
            this.consumerService.start();
            String destination = (String)properties.get("destination");
            this.consumer = new ConsumerThread((JMSService)this.consumerService, destination);
            this.consumer.start();
            LOG.info("Consumer " + pid + " started");
        }
        catch (JMSException e) {
            throw new ConfigurationException(null, "Cannot start consumer", (Throwable)e);
        }
    }

    public void deleted(String pid) {
        this.destroy();
    }

    public void destroy() {
        if (this.consumer != null) {
            this.consumer.setRunning(false);
            this.consumerService.stop();
        }
    }
}

