/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(UuidGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private AtomicLong sequence = new AtomicLong(1L);
    private int length;
    private static UuidGenerator instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UuidGenerator(String prefix) {
        String string = UNIQUE_STUB;
        synchronized (string) {
            int hashValue = prefix.hashCode();
            if (hashValue < 0) {
                hashValue = -hashValue;
            }
            this.seed = hashValue + UNIQUE_STUB + instanceCount++ + ":";
            this.seed = UuidGenerator.generateSanitizedId(this.seed);
            this.length = this.seed.length() + "9223372036854775807".length();
        }
    }

    private UuidGenerator() {
        this("ID:" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    private String generateId() {
        StringBuilder sb = new StringBuilder(this.length);
        sb.append(this.seed);
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    public static String generateSanitizedId(String id) {
        id = id.replace(':', '-');
        id = id.replace('_', '-');
        id = id.replace('.', '-');
        id = id.replace('/', '-');
        return id;
    }

    public static String getUUID() {
        return UuidGenerator.getInstance().generateId();
    }

    public static UuidGenerator getInstance() {
        if (instance == null) {
            instance = new UuidGenerator();
        }
        return instance;
    }

    static String getLocalHostName() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            throw uhe;
        }
    }

    static {
        instance = null;
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = UuidGenerator.getLocalHostName();
                ServerSocket ss = new ServerSocket(0);
                stub = "-" + ss.getLocalPort() + "-" + System.currentTimeMillis() + "-";
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception ioe) {
                LOG.warn("could not generate unique stub", (Throwable)ioe);
            }
        } else {
            hostName = "localhost";
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = stub;
    }
}

