/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.fusesource.fabric.dosgi.api.AsyncCallback;
import org.fusesource.fabric.dosgi.api.SerializationStrategy;
import org.fusesource.fabric.dosgi.tcp.InvocationStrategy;
import org.fusesource.fabric.dosgi.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.Dispatch;

public class BlockingInvocationStrategy
implements InvocationStrategy {
    public static final BlockingInvocationStrategy INSTANCE = new BlockingInvocationStrategy();
    private static final Callable<Object> EMPTY_CALLABLE = new Callable<Object>(){

        @Override
        public Object call() {
            return null;
        }
    };

    @Override
    public ResponseFuture request(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args, DataByteArrayOutputStream target) throws Exception {
        assert (Dispatch.getCurrentQueue() == null) : "You should not do blocking RPC class when executing on a dispatch queue";
        serializationStrategy.encodeRequest(loader, method.getParameterTypes(), args, target);
        return new BlockingResponseFuture(loader, method, serializationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        int pos = responseStream.position();
        try {
            Object value = null;
            Throwable error = null;
            try {
                Class<?>[] types = method.getParameterTypes();
                Object[] args = new Object[types.length];
                serializationStrategy.decodeRequest(loader, types, requestStream, args);
                value = method.invoke(target, args);
            }
            catch (Throwable t) {
                error = t instanceof InvocationTargetException ? t.getCause() : t;
            }
            serializationStrategy.encodeResponse(loader, method.getReturnType(), value, error, responseStream);
        }
        catch (Exception e) {
            try {
                responseStream.position(pos);
                serializationStrategy.encodeResponse(loader, method.getReturnType(), null, new RemoteException(e.toString()), responseStream);
            }
            catch (Exception unexpected) {
                unexpected.printStackTrace();
            }
        }
        finally {
            onComplete.run();
        }
    }

    private class BlockingResponseFuture
    extends FutureTask<Object>
    implements ResponseFuture,
    AsyncCallback {
        private final ClassLoader loader;
        private final Method method;
        private final SerializationStrategy serializationStrategy;

        public BlockingResponseFuture(ClassLoader loader, Method method, SerializationStrategy serializationStrategy) {
            super(EMPTY_CALLABLE);
            this.loader = loader;
            this.method = method;
            this.serializationStrategy = serializationStrategy;
        }

        @Override
        public void set(DataByteArrayInputStream source) throws IOException, ClassNotFoundException {
            try {
                this.serializationStrategy.decodeResponse(this.loader, this.method.getReturnType(), source, this);
            }
            catch (Throwable e) {
                super.setException(e);
            }
        }

        public void onSuccess(Object result) {
            super.set(result);
        }

        @Override
        public void onFailure(Throwable failure) {
            super.setException(failure);
        }
    }
}

