/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.fusesource.fabric.cxf.FailOverTargetSelector;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;

public class LoadBalanceTargetSelector
extends AbstractConduitSelector {
    protected volatile Conduit selectedConduit;
    protected LoadBalanceStrategy loadBalanceStrategy;
    private static final Logger LOG = LogUtils.getL7dLogger(FailOverTargetSelector.class);

    public LoadBalanceTargetSelector() {
        super(null);
    }

    public LoadBalanceTargetSelector(Conduit c) {
        super(c);
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void prepare(Message message) {
        this.getSelectedConduit(message);
    }

    public Conduit selectConduit(Message message) {
        return this.getSelectedConduit(message);
    }

    public void complete(Exchange exchange) {
        super.complete(exchange);
        this.selectedConduit = null;
    }

    protected synchronized Conduit getSelectedConduit(Message message) {
        if (this.selectedConduit == null) {
            this.selectedConduit = this.getNextConduit(message);
        }
        return this.selectedConduit;
    }

    protected Conduit getNextConduit(Message message) {
        Conduit answer = null;
        Exchange exchange = message.getExchange();
        EndpointInfo ei = this.endpoint.getEndpointInfo();
        String address = this.loadBalanceStrategy.getNextAlternateAddress();
        try {
            ConduitInitiatorManager conduitInitiatorMgr = (ConduitInitiatorManager)exchange.getBus().getExtension(ConduitInitiatorManager.class);
            if (conduitInitiatorMgr != null) {
                ConduitInitiator conduitInitiator = conduitInitiatorMgr.getConduitInitiatorForUri(address);
                if (conduitInitiator != null) {
                    EndpointReferenceType epr = new EndpointReferenceType();
                    AttributedURIType ad = new AttributedURIType();
                    ad.setValue(address);
                    epr.setAddress(ad);
                    answer = conduitInitiator.getConduit(ei, epr);
                    MessageObserver observer = (MessageObserver)exchange.get(MessageObserver.class);
                    if (observer != null) {
                        answer.setMessageObserver(observer);
                    } else {
                        this.getLogger().warning("MessageObserver not found");
                    }
                } else {
                    this.getLogger().warning("ConduitInitiator not found: " + ei.getAddress());
                }
            } else {
                this.getLogger().warning("ConduitInitiatorManager not found");
            }
        }
        catch (IOException ex) {
            throw new Fault((Throwable)ex);
        }
        return answer;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }
}

