/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.Group;

public abstract class FabricLoadBalanceStrategySupport
implements LoadBalanceStrategy {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalanceStrategySupport.class);
    protected Group group;
    protected List<String> alternateAddressList = new CopyOnWriteArrayList<String>();

    @Override
    public void setGroup(Group group) {
        this.group = group;
        group.add(new ChangeListener(){

            @Override
            public void changed(byte[][] members2) {
                FabricLoadBalanceStrategySupport.this.alternateAddressList.clear();
                for (byte[] uri : members2) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Added the CXF endpoint address " + new String(uri, "UTF-8")));
                        }
                        FabricLoadBalanceStrategySupport.this.alternateAddressList.add(new String(uri, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ignore) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public List<String> getAlternateAddressList() {
        return new ArrayList<String>(this.alternateAddressList);
    }
}

