/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.configadmin;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.ZkProfiles;
import org.fusesource.fabric.zookeeper.utils.InterpolationHelper;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.fusesource.fabric.zookeeper.utils.ZookeeperCommandBuilder;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.tracker.NodeEvent;
import org.linkedin.zookeeper.tracker.NodeEventsListener;
import org.linkedin.zookeeper.tracker.TrackedNode;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.linkedin.zookeeper.tracker.ZKStringDataReader;
import org.linkedin.zookeeper.tracker.ZooKeeperTreeTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConfigAdminBridge
implements NodeEventsListener<String>,
LifecycleListener {
    public static final String PARENTS = "parents";
    public static final String DELETED = "#deleted#";
    public static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.pid";
    public static final String FILEINSTALL = "felix.fileinstall.filename";
    public static final String PROFILE_PROP_REGEX = "profile:[\\w\\.\\-]*/[\\w\\.\\-]*";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperConfigAdminBridge.class);
    private IZKClient zooKeeper;
    private ConfigurationAdmin configAdmin;
    private String name;
    private String version;
    private String node;
    private String ensemble;
    private String resolutionPolicy;
    private Map<String, ZooKeeperTreeTracker<String>> trees = new ConcurrentHashMap<String, ZooKeeperTreeTracker<String>>();
    private volatile boolean tracking = false;

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
        for (ZooKeeperTreeTracker<String> tree : this.trees.values()) {
            tree.destroy();
        }
        this.trees.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        try {
            this.trees = new ConcurrentHashMap<String, ZooKeeperTreeTracker<String>>();
            this.tracking = true;
            try {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.name});
                if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)versionNode) == null) {
                    ZkPath.createContainerPaths((IZKClient)this.zooKeeper, (String)this.name, null, (String)"fabric");
                }
                this.version = ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)versionNode);
                if (this.version == null) {
                    throw new IllegalStateException("Configuration for node " + this.name + " not found at " + ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.name}));
                }
                this.track(versionNode);
                this.node = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{this.version, this.name});
                if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)this.node) == null) {
                    ZooKeeperUtils.create((IZKClient)this.zooKeeper, (String)this.node);
                }
                this.track(this.node);
                this.ensemble = ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]);
                if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)this.ensemble) == null) {
                    ZooKeeperUtils.create((IZKClient)this.zooKeeper, (String)this.ensemble);
                }
                this.track(this.ensemble);
                this.resolutionPolicy = ZkPath.CONTAINER_RESOLVER.getPath(new String[]{this.name});
                this.track(this.resolutionPolicy);
            }
            finally {
                this.tracking = false;
            }
            this.onEvents(null);
        }
        catch (Exception e) {
            LOGGER.warn("Exception when tracking configurations. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onDisconnected() {
    }

    protected ZooKeeperTreeTracker<String> track(String path) throws InterruptedException, KeeperException, IOException {
        ZooKeeperTreeTracker tree = this.trees.get(path);
        if (tree == null) {
            if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)path) != null) {
                String[] parents;
                tree = new ZooKeeperTreeTracker((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), path);
                this.trees.put(path, (ZooKeeperTreeTracker<String>)tree);
                tree.track((NodeEventsListener)this);
                for (String parent : parents = this.getParents((TrackedNode<String>)((TrackedNode)tree.getTree().get(path)))) {
                    this.track(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, parent}));
                }
            } else {
                String p = ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{this.version});
                if (!this.trees.containsKey(p)) {
                    tree = new ZooKeeperTreeTracker((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), p, 1);
                    this.trees.put(p, (ZooKeeperTreeTracker<String>)tree);
                    tree.track((NodeEventsListener)this);
                }
                return null;
            }
        }
        return tree;
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public Map<String, Hashtable> load(Set<String> pids) throws IOException {
        Hashtable props;
        final HashMap<String, Hashtable> configs = new HashMap<String, Hashtable>();
        for (String string : pids) {
            try {
                props = new Hashtable();
                this.load(string, this.node, props);
                configs.put(string, props);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Error loading pid " + string).initCause(e);
            }
            catch (KeeperException e) {
                throw (IOException)new IOException("Error loading pid " + string).initCause(e);
            }
        }
        for (Map.Entry entry : configs.entrySet()) {
            props = (Hashtable)entry.getValue();
            InterpolationHelper.performSubstitution((Map)props, (InterpolationHelper.SubstitutionCallback)new InterpolationHelper.SubstitutionCallback(){

                public String getValue(String key) {
                    if (key.startsWith("zk:")) {
                        try {
                            return new String((byte[])ZookeeperCommandBuilder.loadUrl((String)key).execute(ZooKeeperConfigAdminBridge.this.zooKeeper), "UTF-8");
                        }
                        catch (KeeperException.ConnectionLossException e) {
                            throw new RuntimeException(e);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not load zk value: {}. This exception will be ignored.", (Object)key, (Object)e);
                        }
                    } else {
                        if (key.matches(ZooKeeperConfigAdminBridge.PROFILE_PROP_REGEX)) {
                            String pid = key.substring("profile:".length(), key.indexOf("/"));
                            String propertyKey = key.substring(key.indexOf("/") + 1);
                            Hashtable targetProps = (Hashtable)configs.get(pid);
                            if (targetProps != null && targetProps.containsKey(propertyKey)) {
                                return (String)targetProps.get(propertyKey);
                            }
                            return key;
                        }
                        String value = "";
                        BundleContext context = ZooKeeperConfigAdminBridge.getBundleContext();
                        if (context != null) {
                            value = context.getProperty(key);
                        }
                        if (value == null) {
                            value = System.getProperty(key, "");
                        }
                        return value;
                    }
                    return "";
                }
            });
        }
        return configs;
    }

    private static BundleContext getBundleContext() {
        try {
            return FrameworkUtil.getBundle(ZooKeeperConfigAdminBridge.class).getBundleContext();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void load(String pid, String node, Dictionary dict) throws KeeperException, InterruptedException, IOException {
        TrackedNode cfg;
        String[] parents;
        ZooKeeperTreeTracker<String> tree = this.track(node);
        TrackedNode root = tree != null ? (TrackedNode)tree.getTree().get(node) : null;
        for (String parent : parents = this.getParents((TrackedNode<String>)root)) {
            this.load(pid, ZkProfiles.getPath((String)this.version, (String)parent), dict);
        }
        TrackedNode trackedNode = cfg = tree != null ? (TrackedNode)tree.getTree().get(node + "/" + pid + ".properties") : null;
        if (cfg != null) {
            Properties properties = ZooKeeperConfigAdminBridge.toProperties((String)cfg.getData());
            if (properties.remove(DELETED) != null) {
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    dict.remove(keys.nextElement());
                }
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (DELETED.equals(entry.getValue())) {
                    dict.remove(entry.getKey());
                    continue;
                }
                dict.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private String[] getParents(TrackedNode<String> root) throws IOException {
        String[] parents;
        if (root != null && root.getData() != null) {
            String key;
            Properties props = ZooKeeperConfigAdminBridge.toProperties((String)root.getData());
            if (props.size() == 1 && !(key = props.stringPropertyNames().iterator().next()).equals(PARENTS)) {
                String val = props.getProperty(key);
                props.remove(key);
                props.setProperty(PARENTS, val.isEmpty() ? key : key + " " + val);
            }
            parents = props.getProperty(PARENTS, "").split(" ");
        } else {
            parents = new String[]{};
        }
        return parents;
    }

    private Set<String> getPids() throws KeeperException, InterruptedException, IOException {
        HashSet<String> pids = new HashSet<String>();
        this.getPids(this.node, pids);
        return pids;
    }

    private void getPids(String node, Set<String> pids) throws KeeperException, InterruptedException, IOException {
        String[] parents;
        ZooKeeperTreeTracker<String> tree = this.track(node);
        TrackedNode root = tree != null ? (TrackedNode)tree.getTree().get(node) : null;
        for (String parent : parents = this.getParents((TrackedNode<String>)root)) {
            this.getPids(ZkProfiles.getPath((String)this.version, (String)parent), pids);
        }
        for (String pid : this.getChildren(tree, node)) {
            if (!pid.endsWith(".properties")) continue;
            pid = ZooKeeperConfigAdminBridge.stripSuffix(pid, ".properties");
            pids.add(pid);
        }
    }

    protected List<String> getChildren(ZooKeeperTreeTracker<String> tree, String node) {
        ArrayList<String> children = new ArrayList<String>();
        if (tree != null) {
            Pattern p = Pattern.compile(node + "/[^/]*");
            for (String c : tree.getTree().keySet()) {
                if (!p.matcher(c).matches()) continue;
                children.add(c.substring(c.lastIndexOf(47) + 1));
            }
        }
        return children;
    }

    public void onEvents(Collection<NodeEvent<String>> nodeEvents) {
        LOGGER.trace("onEvents", nodeEvents);
        try {
            if (!this.tracking) {
                String version = ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.name}));
                if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.name})) != null) {
                    String resolutionPointer = ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.name}));
                    this.resolutionPolicy = ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{this.name}));
                    if (resolutionPointer == null || !resolutionPointer.contains(this.resolutionPolicy)) {
                        ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.name}), (String)("${zk:" + this.name + "/" + this.resolutionPolicy + "}"));
                    }
                    System.setProperty("java.rmi.server.hostname", ZooKeeperUtils.getSubstitutedData((IZKClient)this.zooKeeper, (String)ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.name}))));
                }
                if (!this.version.equals(version)) {
                    this.version = version;
                    this.node = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, this.name});
                    this.track(this.node);
                }
                Set<String> pids = this.getPids();
                Map<String, Hashtable> pidProperties = this.load(pids);
                List<Configuration> configs = ZooKeeperConfigAdminBridge.asList(this.getConfigAdmin().listConfigurations("(fabric.zookeeper.pid=*)"));
                for (String pid : pids) {
                    Hashtable old;
                    Hashtable c = pidProperties.get(pid);
                    String[] p = this.parsePid(pid);
                    Configuration config = this.getConfiguration(pid, p[0], p[1]);
                    configs.remove(config);
                    Dictionary props = config.getProperties();
                    Hashtable hashtable = old = props != null ? new Hashtable() : null;
                    if (old != null) {
                        Enumeration e = props.keys();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            Object val = props.get(key);
                            old.put(key, val);
                        }
                        old.remove(FABRIC_ZOOKEEPER_PID);
                        old.remove("service.pid");
                        old.remove("service.factoryPid");
                    }
                    if (!c.equals(old)) {
                        LOGGER.info("Updating configuration {}", (Object)config.getPid());
                        c.put(FABRIC_ZOOKEEPER_PID, pid);
                        if (config.getBundleLocation() != null) {
                            config.setBundleLocation(null);
                        }
                        config.update((Dictionary)c);
                        continue;
                    }
                    LOGGER.info("Ignoring configuration {} (no changes)", (Object)config.getPid());
                }
                for (Configuration config : configs) {
                    LOGGER.info("Deleting configuration {}", (Object)config.getPid());
                    config.delete();
                }
            }
            LOGGER.trace("onEvents done");
        }
        catch (Exception e) {
            LOGGER.warn("Exception when tracking configurations. This exception will be ignored.", (Throwable)e);
        }
    }

    public static <T> List<T> asList(T ... a) {
        ArrayList l = new ArrayList();
        if (a != null) {
            Collections.addAll(l, a);
        }
        return l;
    }

    String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String zooKeeperPid, String pid, String factoryPid) throws Exception {
        String filter = "(fabric.zookeeper.pid=" + zooKeeperPid + ")";
        Configuration[] oldConfiguration = this.getConfigAdmin().listConfigurations(filter);
        if (oldConfiguration != null && oldConfiguration.length > 0) {
            return oldConfiguration[0];
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigAdmin().createFactoryConfiguration(pid, null) : this.getConfigAdmin().getConfiguration(pid, null);
        return newConfiguration;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

