/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ZKServerFactoryBean
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, Object> servers = new HashMap<String, Object>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "ZooKeeper Server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        block14: {
            try {
                this.deleted(pid);
                Properties props = new Properties();
                Enumeration ek = properties.keys();
                while (ek.hasMoreElements()) {
                    Object key = ek.nextElement();
                    Object val = properties.get(key);
                    props.put(key.toString(), val != null ? val.toString() : "");
                }
                String serverId = props.getProperty("server.id");
                if (serverId != null) {
                    props.remove("server.id");
                    File myId = new File(props.getProperty("dataDir"), "myid");
                    if (myId.exists()) {
                        myId.delete();
                    }
                    myId.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(myId);
                    try {
                        fos.write((serverId + "\n").getBytes());
                    }
                    finally {
                        fos.close();
                    }
                }
                QuorumPeerConfig config = new QuorumPeerConfig();
                config.parseProperties(props);
                if (!config.getServers().isEmpty()) {
                    NIOServerCnxn.Factory cnxnFactory = new NIOServerCnxn.Factory(config.getClientPortAddress(), config.getMaxClientCnxns());
                    QuorumPeer quorumPeer = new QuorumPeer();
                    quorumPeer.setClientPortAddress(config.getClientPortAddress());
                    quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir())));
                    quorumPeer.setQuorumPeers(config.getServers());
                    quorumPeer.setElectionType(config.getElectionAlg());
                    quorumPeer.setMyid(config.getServerId());
                    quorumPeer.setTickTime(config.getTickTime());
                    quorumPeer.setMinSessionTimeout(config.getMinSessionTimeout());
                    quorumPeer.setMaxSessionTimeout(config.getMaxSessionTimeout());
                    quorumPeer.setInitLimit(config.getInitLimit());
                    quorumPeer.setSyncLimit(config.getSyncLimit());
                    quorumPeer.setQuorumVerifier(config.getQuorumVerifier());
                    quorumPeer.setCnxnFactory(cnxnFactory);
                    quorumPeer.setZKDatabase(new ZKDatabase(quorumPeer.getTxnFactory()));
                    quorumPeer.setLearnerType(config.getPeerType());
                    try {
                        quorumPeer.start();
                    }
                    catch (Exception e) {
                        quorumPeer.shutdown();
                        throw e;
                    }
                    this.servers.put(pid, quorumPeer);
                    this.services.put(pid, this.bundleContext.registerService(QuorumStats.Provider.class.getName(), (Object)quorumPeer, properties));
                    break block14;
                }
                ServerConfig cfg = new ServerConfig();
                cfg.readFrom(config);
                ZooKeeperServer zkServer = new ZooKeeperServer();
                FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(cfg.getDataLogDir()), new File(cfg.getDataDir()));
                zkServer.setTxnLogFactory(ftxn);
                zkServer.setTickTime(cfg.getTickTime());
                zkServer.setMinSessionTimeout(cfg.getMinSessionTimeout());
                zkServer.setMaxSessionTimeout(cfg.getMaxSessionTimeout());
                NIOServerCnxn.Factory cnxnFactory = new NIOServerCnxn.Factory(cfg.getClientPortAddress(), cfg.getMaxClientCnxns());
                try {
                    cnxnFactory.startup(zkServer);
                }
                catch (Exception e) {
                    cnxnFactory.shutdown();
                    throw e;
                }
                this.servers.put(pid, cnxnFactory);
                this.services.put(pid, this.bundleContext.registerService(ServerStats.Provider.class.getName(), (Object)zkServer, properties));
            }
            catch (Exception e) {
                throw (ConfigurationException)new ConfigurationException(null, "Unable to parse ZooKeeper configuration: " + e.getMessage()).initCause((Throwable)e);
            }
        }
    }

    public synchronized void deleted(String pid) {
        Object obj = this.servers.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
        if (obj instanceof QuorumPeer) {
            ((QuorumPeer)obj).shutdown();
        } else if (obj instanceof NIOServerCnxn.Factory) {
            ((NIOServerCnxn.Factory)obj).shutdown();
        }
    }

    public void destroy() throws Exception {
        while (!this.servers.isEmpty()) {
            String pid = this.servers.keySet().iterator().next();
            this.deleted(pid);
        }
    }
}

