/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.jledit.ContentManager;

public class ZookeeperContentManager
implements ContentManager {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final IZKClient zookeeper;

    public ZookeeperContentManager(IZKClient zookeeper) {
        this.zookeeper = zookeeper;
    }

    public String load(String location) throws IOException {
        try {
            String data = this.zookeeper.getStringData(location);
            return data != null ? data : "";
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to read data from zookeeper.", e);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to read data from zookeeper.", e);
        }
    }

    public boolean save(String content, String location) {
        try {
            ZooKeeperUtils.set((IZKClient)this.zookeeper, (String)location, (String)content);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean save(String content, Charset charset, String location) {
        return this.save(content, location);
    }

    public Charset detectCharset(String location) {
        return UTF_8;
    }
}

