/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.commands.ContainerLifecycleCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="container-delete", scope="fabric", description="Stops and deletes an existing container", detailedDescription="classpath:containerDelete.txt")
public class ContainerDelete
extends ContainerLifecycleCommand {
    @Option(name="-r", aliases={"--recursive"}, multiValued=false, required=false, description="Recursively stops and deletes all child containers")
    protected Boolean recursive = Boolean.FALSE;
    @Option(name="-f", aliases={"--force"}, multiValued=false, required=false, description="Forces the deletion of the container.")
    protected Boolean force = Boolean.FALSE;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        if (this.isPartOfEnsemble(this.container) && !this.force.booleanValue()) {
            System.out.println("Container is part of the ensemble. If you still want to delete it, please use -f option.");
            return null;
        }
        Container found = this.getContainer(this.container);
        this.applyUpdatedCredentials(found);
        if (this.recursive.booleanValue()) {
            for (Container child : found.getChildren()) {
                child.stop();
                child.destroy();
            }
        }
        found.stop();
        found.destroy();
        return null;
    }
}

