/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="profile-refresh", scope="fabric", description="Performs a change to the profile, that triggers the deployment agent. It's intended to be used for scanning for snapshot changes", detailedDescription="classpath:profileRefresh.txt")
public class ProfileRefresh
extends FabricCommand {
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionName = "1.0";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateProfileName(this.profileName);
        Version version = this.versionName != null ? this.fabricService.getVersion(this.versionName) : this.fabricService.getDefaultVersion();
        Profile profile = this.fabricService.getProfile(version.getName(), this.profileName);
        if (profile == null) {
            throw new IllegalArgumentException("No profile found with name:" + this.profileName + " and version:" + version.getName());
        }
        Map configuration = profile.getConfigurations();
        HashMap<String, String> agentConfiguration = (HashMap<String, String>)configuration.get("org.fusesource.fabric.agent");
        if (agentConfiguration == null) {
            agentConfiguration = new HashMap<String, String>();
        }
        agentConfiguration.put("lastRefresh." + this.profileName, String.valueOf(System.currentTimeMillis()));
        profile.setConfigurations(configuration);
        return null;
    }
}

