/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.KeeperException;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;

@Command(name="cluster-list", scope="fabric", description="Lists all ActiveMQ message brokers in the fabric, enabling you to see which brokers are grouped into clusters.")
public class ClusterList
extends FabricCommand {
    protected static String CLUSTER_PREFIX = "/fabric/registry/clusters";
    @Argument(required=false, description="Path of the fabric registry node (Zookeeper registry node) to list. Relative paths are evaluated relative to the base node, /fabric/registry/clusters. If not specified, all clusters are listed.")
    String path = "";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        String realPath = this.path;
        if (!realPath.startsWith("/")) {
            realPath = CLUSTER_PREFIX;
            if (this.path.length() > 0) {
                realPath = realPath + "/" + this.path;
            }
        }
        this.printCluster(realPath, System.out);
        return null;
    }

    protected void printCluster(String dir, PrintStream out) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        if (this.getZooKeeper().exists(dir) == null) {
            return;
        }
        List children = this.getZooKeeper().getAllChildren(dir);
        HashMap clusters = new HashMap();
        for (String child : children) {
            String text;
            String childDir = dir + "/" + child;
            byte[] data = this.getZooKeeper().getData(childDir);
            if (data == null || data.length <= 0 || (text = new String(data).trim()).isEmpty()) continue;
            String clusterName = this.getClusterName(dir, childDir);
            HashMap<String, ClusterNode> cluster = (HashMap<String, ClusterNode>)clusters.get(clusterName);
            if (cluster == null) {
                cluster = new HashMap<String, ClusterNode>();
                clusters.put(clusterName, cluster);
            }
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(data, HashMap.class);
            ClusterNode node = null;
            Object id = this.value(map, "id", "container");
            if (id == null) continue;
            Object agent = this.value(map, "agent");
            List services = (List)this.value(map, "services");
            node = (ClusterNode)cluster.get(id);
            if (node == null) {
                node = new ClusterNode();
                cluster.put(id.toString(), node);
            }
            if (services != null) {
                if (!services.isEmpty()) {
                    for (Object service : services) {
                        node.services.add(ZooKeeperUtils.getSubstitutedData((IZKClient)this.getZooKeeper(), (String)service.toString()));
                    }
                    node.masters.add(agent);
                    continue;
                }
                node.slaves.add(agent);
                continue;
            }
            node.slaves.add(agent);
        }
        out.println(String.format("%-30s %-30s %-30s %s", "[cluster]", "[masters]", "[slaves]", "[services]"));
        for (String clusterName : clusters.keySet()) {
            HashMap nodes = (HashMap)clusters.get(clusterName);
            out.println(String.format("%-30s %-30s %-30s %s", clusterName, "", "", "", ""));
            for (String nodeName : nodes.keySet()) {
                ClusterNode node = (ClusterNode)nodes.get(nodeName);
                out.println(String.format("%-30s %-30s %-30s %s", "   " + nodeName, this.printList(node.masters), this.printList(node.slaves), this.printList(node.services)));
            }
        }
    }

    protected String printList(List list) {
        if (list.isEmpty()) {
            return "-";
        }
        String text = list.toString();
        return text.substring(1, text.length() - 1);
    }

    protected Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String getClusterName(String rootDir, String dir) {
        String clusterName = dir;
        if ((clusterName = clusterName.substring(0, clusterName.lastIndexOf("/"))).startsWith(rootDir)) {
            clusterName = clusterName.substring(rootDir.length());
        }
        if (clusterName.startsWith("/")) {
            clusterName = clusterName.substring(1);
        }
        if (clusterName.length() == 0) {
            clusterName = ".";
        }
        return clusterName;
    }

    protected class ClusterNode {
        public List masters = new ArrayList();
        public List services = new ArrayList();
        public List slaves = new ArrayList();

        protected ClusterNode() {
        }

        public String toString() {
            return this.masters + " " + this.services + " " + this.slaves;
        }
    }
}

