/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.FabricAuthenticationException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.service.MQServiceImpl;
import org.fusesource.fabric.utils.shell.ShellUtils;

@Command(name="mq-create", scope="fabric", description="Create a new broker")
public class MQCreate
extends FabricCommand {
    @Argument(index=0, required=true, description="Broker name")
    protected String name = null;
    @Option(name="--config", description="Configuration to use")
    protected String config;
    @Option(name="--data", description="Data directory for the broker")
    protected String data;
    @Option(name="--group", description="Broker group")
    protected String group;
    @Option(name="--networks", description="Broker networks")
    protected String networks;
    @Option(name="--version", description="The version id in the registry")
    protected String version = "1.0";
    @Option(name="--create-container", multiValued=false, required=false, description="Comma separated list of child containers to create with mq profile")
    protected String create;
    @Option(name="--assign-container", multiValued=false, required=false, description="Assign this mq profile to the following containers")
    protected String assign;
    @Option(name="--jmx-user", multiValued=false, required=false, description="The jmx user name of the parent container.")
    protected String username;
    @Option(name="--jmx-password", multiValued=false, required=false, description="The jmx password of the parent container.")
    protected String password;
    @Option(name="--jvm-opts", multiValued=false, required=false, description="Options to pass to the container's JVM.")
    protected String jvmOpts;

    protected Object doExecute() throws Exception {
        MQServiceImpl service = new MQServiceImpl(this.fabricService);
        HashMap<String, String> configuration = new HashMap<String, String>();
        if (this.data == null) {
            this.data = System.getProperty("karaf.base") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + this.name;
        }
        configuration.put("data", this.data);
        if (this.config != null) {
            configuration.put("config", service.getConfig(this.version, this.config));
        }
        if (this.group != null) {
            configuration.put("group", this.group);
        }
        if (this.networks != null) {
            configuration.put("network", this.networks);
        }
        Profile profile = service.createMQProfile(this.version, this.name, configuration);
        System.out.println("MQ profile " + profile.getId() + " ready");
        if (this.assign != null) {
            String[] assignContainers;
            for (String containerName : assignContainers = this.assign.split(",")) {
                try {
                    Container container = this.fabricService.getContainer(containerName);
                    if (container == null) {
                        System.out.println("Failed to assign profile to " + containerName + ": profile doesn't exists");
                        continue;
                    }
                    HashSet<Profile> profiles = new HashSet<Profile>(Arrays.asList(container.getProfiles()));
                    profiles.add(profile);
                    container.setProfiles(profiles.toArray(new Profile[profiles.size()]));
                    System.out.println("Profile successfully assigned to " + containerName);
                }
                catch (Exception e) {
                    System.out.println("Failed to assign profile to " + containerName + ": " + e.getMessage());
                }
            }
        }
        if (this.create != null) {
            String[] createContainers;
            for (String url : createContainers = this.create.split(",")) {
                CreateContainerMetadata[] metadatas;
                String type = null;
                String parent = this.fabricService.getCurrentContainerName();
                String name = url;
                if (url.contains("://")) {
                    URI uri = new URI(url);
                    type = uri.getScheme();
                    parent = null;
                    name = uri.getHost();
                } else {
                    type = "child";
                    url = "child://" + parent;
                }
                if (!type.equals("child")) {
                    throw new Exception("mq-create command can only create child containers. For any other kind, create your container first and then use --assign");
                }
                String jmxUser = this.username != null ? this.username : ShellUtils.retrieveFabricUser(this.session);
                String jmxPassword = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
                CreateContainerChildOptions args = ((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)CreateContainerOptionsBuilder.child().name(name)).parent(parent)).number(1)).ensembleServer(false)).providerUri(url)).proxyUri(this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts)).jmxUser(jmxUser).jmxPassword(jmxPassword);
                try {
                    metadatas = this.fabricService.createContainers((CreateContainerOptions)args);
                    ShellUtils.storeFabricCredentials(this.session, jmxUser, jmxPassword);
                }
                catch (FabricAuthenticationException fae) {
                    this.promptForJmxCredentialsIfNeeded();
                    args.setJmxUser(this.username);
                    args.setJmxPassword(this.password);
                    metadatas = this.fabricService.createContainers((CreateContainerOptions)args);
                    ShellUtils.storeFabricCredentials(this.session, this.username, this.password);
                }
                for (CreateContainerMetadata metadata : metadatas) {
                    if (metadata.isSuccess()) {
                        Container child = metadata.getContainer();
                        child.setProfiles(new Profile[]{profile});
                        System.out.println("Successfully created container " + metadata.getContainerName());
                        continue;
                    }
                    System.out.println("Failed to create container " + metadata.getContainerName() + ": " + metadata.getFailure().getMessage());
                }
            }
        }
        return null;
    }

    private void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.username == null) {
            this.log.debug("Prompting user for jmx login");
            this.username = ShellUtils.readLine(this.session, "Jmx Login for " + this.fabricService.getCurrentContainerName() + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "Jmx Password for " + this.fabricService.getCurrentContainerName() + ": ", true);
        }
    }
}

