/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="container-remove-profile", scope="fabric", description="Removes a profile form container's list of profiles.")
public class ContainerRemoveProfile
extends FabricCommand {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="profiles", description="The profiles to remove from the container", required=true, multiValued=true)
    private List<String> profiles;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Container cont = this.getContainer(this.container);
        Profile[] existingProfiles = cont.getProfiles();
        LinkedList<String> updatedProfiles = new LinkedList<String>();
        if (existingProfiles != null) {
            for (Profile existingProfile : existingProfiles) {
                if (this.profiles.contains(existingProfile.getId())) continue;
                updatedProfiles.add(existingProfile.getId());
            }
        }
        Profile[] profs = this.getProfiles(cont.getVersion(), updatedProfiles);
        cont.setProfiles(profs);
        return null;
    }
}

