/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.IOException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.FabricAuthenticationException;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;
import org.fusesource.fabric.utils.shell.ShellUtils;

@Command(name="container-create-child", scope="fabric", description="Creates one or more child containers", detailedDescription="classpath:containerCreateChild.txt")
public class ContainerCreateChild
extends ContainerCreateSupport {
    @Option(name="--jmx-user", multiValued=false, required=false, description="The jmx user name of the parent container.")
    protected String username;
    @Option(name="--jmx-password", multiValued=false, required=false, description="The jmx password of the parent container.")
    protected String password;
    @Argument(index=0, required=true, description="Parent containers ID")
    protected String parent;
    @Argument(index=1, required=true, description="The name of the containers to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=2, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        CreateContainerMetadata[] metadatas = null;
        this.preCreateContainer(this.name);
        String jmxUser = this.username != null ? this.username : ShellUtils.retrieveFabricUser(this.session);
        String jmxPassword = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        String url = "child://" + this.parent;
        CreateContainerChildOptions options = ((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)CreateContainerOptionsBuilder.child().name(this.name)).parent(this.parent)).providerUri(url)).resolver(this.resolver)).ensembleServer(this.isEnsembleServer.booleanValue())).number(this.number)).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts)).jmxUser(jmxUser).jmxPassword(jmxPassword);
        try {
            metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
            ShellUtils.storeFabricCredentials(this.session, jmxUser, jmxPassword);
        }
        catch (FabricAuthenticationException ex) {
            this.promptForJmxCredentialsIfNeeded();
            options.setJmxUser(this.username);
            options.setJmxPassword(this.password);
            metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
            ShellUtils.storeFabricCredentials(this.session, this.username, this.password);
        }
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 1 || this.number > 99) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 99.");
        }
        if (this.isEnsembleServer.booleanValue() && this.number > 1) {
            throw new IllegalArgumentException("Can not create a new ZooKeeper ensemble on multiple containers.  Create the containers first and then use the fabric:create command instead.");
        }
    }

    private void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.username == null) {
            this.log.debug("Prompting user for jmx login");
            this.username = ShellUtils.readLine(this.session, "Jmx Login for " + this.parent + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "Jmx Password for " + this.parent + ": ", true);
        }
    }
}

