/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.commands.support.CommandUtils;

@Command(name="version-list", scope="fabric", description="List the existing versions")
public class VersionList
extends FabricCommand {
    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Container[] containers = this.fabricService.getContainers();
        Version[] versions = this.fabricService.getVersions();
        this.printVersions(containers, versions, this.fabricService.getDefaultVersion(), System.out);
        return null;
    }

    protected void printVersions(Container[] containers, Version[] versions, Version defaultVersion, PrintStream out) {
        out.println(String.format("%-15s %-9s %-14s", "[version]", "[default]", "[# containers]"));
        for (Version version : versions) {
            boolean isDefault = defaultVersion.getName().equals(version.getName());
            int active = CommandUtils.countContainersByVersion(containers, version);
            out.println(String.format("%-15s %-9s %-14s", version.getName(), isDefault ? "true" : "false", active));
        }
    }
}

