/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="version-create", scope="fabric", description="Create a new version, copying all of the profiles from the current latest version into the new version")
public class VersionCreate
extends FabricCommand {
    @Option(name="--parent", description="The parent version. By default, use the latest version as the parent.")
    private String parentVersion;
    @Option(name="--default", description="Set the created version to be the new default version.")
    private Boolean defaultVersion;
    @Argument(index=0, description="The new version to create. If not specified, defaults to the next minor version.", required=false)
    private String name;

    protected Object doExecute() throws Exception {
        Version created;
        Version parent;
        this.checkFabricAvailable();
        Version latestVersion = null;
        Version[] versions = this.fabricService.getVersions();
        int vlength = versions.length;
        if (vlength > 0) {
            latestVersion = versions[vlength - 1];
        }
        if (this.name == null) {
            if (latestVersion == null) {
                throw new IllegalArgumentException("Cannot default the new version name as there are no versions available");
            }
            this.name = latestVersion.getSequence().next().getName();
        }
        if (this.parentVersion == null) {
            parent = latestVersion;
        } else {
            parent = this.fabricService.getVersion(this.parentVersion);
            if (parent == null) {
                throw new IllegalArgumentException("Cannot find parent version: " + this.parentVersion);
            }
        }
        if (parent != null) {
            created = this.fabricService.createVersion(parent, this.name);
            System.out.println("Created version: " + this.name + " as copy of: " + parent.getName());
        } else {
            created = this.fabricService.createVersion(this.name);
            System.out.println("Created version: " + this.name);
        }
        if (this.defaultVersion != null && this.defaultVersion.booleanValue()) {
            this.fabricService.setDefaultVersion(created);
        }
        return null;
    }
}

