/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.commands.support.CommandUtils;

@Command(name="profile-list", scope="fabric", description="Lists all profiles that belong to the specified version (where the version defaults to the current default version)")
public class ProfileList
extends FabricCommand {
    @Option(name="--version", description="Specifies the version of the profiles to list. Defaults to the current default version.")
    private String version;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile[] profiles = ver.getProfiles();
        profiles = CommandUtils.sortProfiles(profiles);
        this.printProfiles(profiles, System.out);
        return null;
    }

    protected void printProfiles(Profile[] profiles, PrintStream out) {
        out.println(String.format("%-40s %-14s %s", "[id]", "[# containers]", "[parents]"));
        for (Profile profile : profiles) {
            int active = profile.getAssociatedContainers().length;
            out.println(String.format("%-40s %-14s %s", profile.getId(), active, this.toString(profile.getParents())));
        }
    }
}

